/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh.term;

import java.security.PublicKey;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.Session;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.crsh.auth.AuthenticationPlugin;
import org.crsh.plugin.PluginContext;
import org.crsh.ssh.term.CRaSHCommandFactory;
import org.crsh.ssh.term.URLKeyPairProvider;
import org.crsh.ssh.term.scp.SCPCommandFactory;
import org.crsh.term.TermLifeCycle;
import org.crsh.term.spi.TermIOHandler;
import org.crsh.vfs.Resource;

public class SSHLifeCycle
extends TermLifeCycle {
    public static final Session.AttributeKey<String> USERNAME = new Session.AttributeKey();
    public static final Session.AttributeKey<String> PASSWORD = new Session.AttributeKey();
    private final Logger log = Logger.getLogger(SSHLifeCycle.class.getName());
    private SshServer server;
    private int port;
    private int idleTimeout;
    private int authTimeout;
    private Resource key;
    private final AuthenticationPlugin authentication;
    private Integer localPort;

    public SSHLifeCycle(PluginContext context, AuthenticationPlugin<?> authentication) {
        super(context);
        this.authentication = authentication;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public int getAuthTimeout() {
        return this.authTimeout;
    }

    public void setAuthTimeout(int authTimeout) {
        this.authTimeout = authTimeout;
    }

    public Integer getLocalPort() {
        return this.localPort;
    }

    public Resource getKey() {
        return this.key;
    }

    public void setKey(Resource key) {
        this.key = key;
    }

    protected void doInit() {
        try {
            TermIOHandler handler = this.getHandler();
            SshServer server = SshServer.setUpDefaultServer();
            server.setPort(this.port);
            if (this.idleTimeout > 0) {
                server.getProperties().put("idle-timeout", String.valueOf(this.idleTimeout));
            }
            if (this.authTimeout > 0) {
                server.getProperties().put("auth-timeout", String.valueOf(this.authTimeout));
            }
            server.setShellFactory((Factory)new CRaSHCommandFactory(handler));
            server.setCommandFactory((CommandFactory)new SCPCommandFactory(this.getContext()));
            server.setKeyPairProvider((KeyPairProvider)new URLKeyPairProvider(this.key));
            if (this.authentication.getCredentialType().equals(String.class)) {
                final AuthenticationPlugin passwordAuthentication = this.authentication;
                server.setPasswordAuthenticator(new PasswordAuthenticator(){

                    public boolean authenticate(String _username, String _password, ServerSession session) {
                        boolean auth;
                        try {
                            SSHLifeCycle.this.log.log(Level.FINE, "Using authentication plugin " + SSHLifeCycle.this.authentication + " to authenticate user " + _username);
                            auth = passwordAuthentication.authenticate(_username, (Object)_password);
                        }
                        catch (Exception e) {
                            SSHLifeCycle.this.log.log(Level.SEVERE, "Exception authenticating user " + _username + " in authentication plugin: " + SSHLifeCycle.this.authentication, e);
                            return false;
                        }
                        session.setAttribute(USERNAME, (Object)_username);
                        session.setAttribute(PASSWORD, (Object)_password);
                        return auth;
                    }
                });
            } else if (this.authentication.getCredentialType().equals(PublicKey.class)) {
                final AuthenticationPlugin keyAuthentication = this.authentication;
                server.setPublickeyAuthenticator(new PublickeyAuthenticator(){

                    public boolean authenticate(String username, PublicKey key, ServerSession session) {
                        try {
                            SSHLifeCycle.this.log.log(Level.FINE, "Using authentication plugin " + SSHLifeCycle.this.authentication + " to authenticate user " + username);
                            return keyAuthentication.authenticate(username, (Object)key);
                        }
                        catch (Exception e) {
                            SSHLifeCycle.this.log.log(Level.SEVERE, "Exception authenticating user " + username + " in authentication plugin: " + SSHLifeCycle.this.authentication, e);
                            return false;
                        }
                    }
                });
            }
            this.log.log(Level.INFO, "About to start CRaSSHD");
            server.start();
            this.localPort = server.getPort();
            this.log.log(Level.INFO, "CRaSSHD started on port " + this.localPort);
            this.server = server;
        }
        catch (Throwable e) {
            this.log.log(Level.SEVERE, "Could not start CRaSSHD", e);
        }
    }

    protected void doDestroy() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (InterruptedException e) {
                this.log.log(Level.FINE, "Got an interruption when stopping server", e);
            }
        }
    }
}

