/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

public class BlankSequence
implements CharSequence {
    private static final BlankSequence[] CACHE = new BlankSequence[64];
    private final int length;
    private String value;

    public static BlankSequence create(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("No negative length accepted");
        }
        if (length < CACHE.length) {
            return CACHE[length];
        }
        return new BlankSequence(length);
    }

    private BlankSequence(int length) throws IllegalArgumentException {
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        this.length = length;
        this.value = null;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        this.checkIndex("index", index);
        return ' ';
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        this.checkIndex("start", start);
        this.checkIndex("end", end);
        if (start > end) {
            throw new IndexOutOfBoundsException("Start " + start + " cannot greater than end " + end);
        }
        return new BlankSequence(end - start);
    }

    @Override
    public String toString() {
        if (this.value == null) {
            if (this.length == 0) {
                this.value = "";
            } else {
                char[] chars = new char[this.length];
                for (int i = 0; i < this.length; ++i) {
                    chars[i] = 32;
                }
                this.value = new String(chars, 0, chars.length);
            }
        }
        return this.value;
    }

    private void checkIndex(String name, int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("No negative " + name + " value " + index);
        }
        if (index >= this.length) {
            throw new IndexOutOfBoundsException("The " + name + " value " + index + " cannot greater than length " + this.length);
        }
    }

    static {
        for (int i = 0; i < CACHE.length; ++i) {
            BlankSequence.CACHE[i] = new BlankSequence(i);
        }
    }
}

