/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.lang;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import org.crsh.cli.SyntaxException;
import org.crsh.cli.descriptor.ArgumentDescriptor;
import org.crsh.cli.descriptor.CommandDescriptor;
import org.crsh.cli.descriptor.Description;
import org.crsh.cli.descriptor.OptionDescriptor;
import org.crsh.cli.descriptor.ParameterDescriptor;
import org.crsh.cli.impl.descriptor.CommandDescriptorImpl;
import org.crsh.cli.impl.descriptor.IntrospectionException;
import org.crsh.cli.impl.invocation.CommandInvoker;
import org.crsh.cli.impl.invocation.InvocationException;
import org.crsh.cli.impl.invocation.InvocationMatch;
import org.crsh.cli.impl.invocation.ParameterMatch;
import org.crsh.cli.impl.invocation.Resolver;
import org.crsh.cli.impl.lang.ClassDescriptor;
import org.crsh.cli.impl.lang.MethodArgumentBinding;

class MethodDescriptor<T>
extends CommandDescriptorImpl<T> {
    private final ClassDescriptor<T> owner;
    private final Method method;
    private final int size;

    public MethodDescriptor(ClassDescriptor<T> owner, Method method, String name, Description info) throws IntrospectionException {
        super(name, info);
        this.owner = owner;
        this.method = method;
        this.size = method.getParameterTypes().length;
    }

    ParameterDescriptor getParameter(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Bad index value " + index);
        }
        for (ParameterDescriptor argument : this.getParameters()) {
            if (((MethodArgumentBinding)argument.getBinding()).getIndex() != index) continue;
            return argument;
        }
        return null;
    }

    @Override
    protected void addParameter(ParameterDescriptor parameter) throws IntrospectionException, NullPointerException, IllegalArgumentException {
        super.addParameter(parameter);
    }

    @Override
    public CommandDescriptor<T> getOwner() {
        return this.owner;
    }

    @Override
    public Map<String, ? extends CommandDescriptorImpl<T>> getSubordinates() {
        return Collections.emptyMap();
    }

    @Override
    public CommandDescriptorImpl<T> getSubordinate(String name) {
        return null;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public Class<T> getType() {
        return this.owner.getType();
    }

    @Override
    public CommandInvoker<T> getInvoker(final InvocationMatch<T> _match) {
        return new CommandInvoker<T>(){

            @Override
            public Class<?> getReturnType() {
                return MethodDescriptor.this.getMethod().getReturnType();
            }

            @Override
            public Type getGenericReturnType() {
                return MethodDescriptor.this.getMethod().getGenericReturnType();
            }

            @Override
            public Class<?>[] getParameterTypes() {
                return MethodDescriptor.this.getMethod().getParameterTypes();
            }

            @Override
            public Type[] getGenericParameterTypes() {
                return MethodDescriptor.this.getMethod().getGenericParameterTypes();
            }

            @Override
            public Object invoke(Resolver resolver, T command) throws InvocationException, SyntaxException {
                MethodDescriptor.this.owner.configure(_match.owner(), command);
                Method m = MethodDescriptor.this.getMethod();
                Class<?>[] parameterTypes = m.getParameterTypes();
                Object[] mArgs = new Object[parameterTypes.length];
                for (int i = 0; i < mArgs.length; ++i) {
                    ParameterMatch<ParameterDescriptor> match;
                    ParameterDescriptor parameter = MethodDescriptor.this.getParameter(i);
                    Class<?> parameterType = parameterTypes[i];
                    Object v = parameter == null ? resolver.resolve(parameterType) : ((match = _match.getParameter(parameter)) != null ? match.computeValue() : null);
                    if (v == null && (parameterType.isPrimitive() || parameter.isRequired())) {
                        if (parameter instanceof ArgumentDescriptor) {
                            ArgumentDescriptor argument = (ArgumentDescriptor)parameter;
                            throw new SyntaxException("Missing argument " + argument.getName());
                        }
                        OptionDescriptor option = (OptionDescriptor)parameter;
                        throw new SyntaxException("Missing option " + option.getNames());
                    }
                    mArgs[i] = v;
                }
                try {
                    return m.invoke(command, mArgs);
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    throw new InvocationException(t);
                }
                catch (IllegalAccessException t) {
                    throw new InvocationException(t);
                }
            }
        };
    }
}

