/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.util.Collections;
import org.crsh.shell.ScreenContext;
import org.crsh.text.CLS;
import org.crsh.text.Color;
import org.crsh.text.Decoration;
import org.crsh.text.RenderAppendable;
import org.crsh.text.RenderWriter;
import org.crsh.text.Style;
import org.crsh.text.ui.Element;
import org.crsh.text.ui.UIBuilder;
import org.crsh.text.ui.UIBuilderRenderable;

public class RenderPrintWriter
extends PrintWriter {
    private final RenderWriter out;

    public RenderPrintWriter(ScreenContext out) {
        super(new RenderWriter(out));
        this.out = (RenderWriter)((PrintWriter)this).out;
    }

    public RenderPrintWriter(ScreenContext out, Closeable closeable) {
        super(new RenderWriter(out, closeable));
        this.out = (RenderWriter)((PrintWriter)this).out;
    }

    public final boolean isEmpty() {
        return this.out.isEmpty();
    }

    public final void print(Object obj, Color foreground) {
        try {
            this.out.provide(Style.style(foreground));
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.setError();
        }
        this.print(obj);
        try {
            this.out.provide(Style.reset);
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.setError();
        }
    }

    public final void println(Object obj, Color foreground) {
        this.print(obj, Style.style(foreground));
        this.println();
    }

    public final void print(Object obj, Color foreground, Color background) {
        try {
            this.out.provide(Style.style(foreground, background));
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.setError();
        }
        this.print(obj);
        try {
            this.out.provide(Style.reset);
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.setError();
        }
    }

    public final void println(Object obj, Color foreground, Color background) {
        this.print(obj, Style.style(foreground, background));
        this.println();
    }

    public final void print(Object obj, Decoration decoration) {
        try {
            this.out.provide(Style.style(decoration));
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.setError();
        }
        this.print(obj);
        try {
            this.out.provide(Style.reset);
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.setError();
        }
    }

    public final void println(Object obj, Decoration decoration) {
        this.print(obj, Style.style(decoration));
        this.println();
    }

    public final void print(Object obj, Decoration decoration, Color foreground) {
        this.print(obj, Style.style(decoration, foreground));
        this.println();
    }

    public final void println(Object obj, Decoration decoration, Color foreground) {
        this.print(obj, Style.style(decoration, foreground, null));
        this.println();
    }

    public final void print(Object obj, Decoration decoration, Color foreground, Color background) {
        this.print(obj, Style.style(decoration, foreground, background));
        this.println();
    }

    public final void println(Object obj, Decoration decoration, Color foreground, Color background) {
        this.print(obj, Style.style(decoration, foreground, background));
        this.println();
    }

    public final void print(Object obj, Style style) {
        try {
            this.out.provide(style);
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.setError();
        }
        this.print(obj);
        try {
            this.out.provide(Style.reset);
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.setError();
        }
    }

    public final void println(Object obj, Style style) {
        this.print(obj, style);
        this.println();
    }

    public final RenderPrintWriter leftShift(Object o) {
        if (o instanceof Style) {
            try {
                this.out.provide((Style)o);
            }
            catch (InterruptedIOException x) {
                Thread.currentThread().interrupt();
            }
            catch (IOException x) {
                this.setError();
            }
        } else if (o instanceof Decoration) {
            try {
                this.out.provide(Style.style((Decoration)((Object)o)));
            }
            catch (InterruptedIOException x) {
                Thread.currentThread().interrupt();
            }
            catch (IOException x) {
                this.setError();
            }
        } else if (o instanceof Color) {
            try {
                this.out.provide(Style.style((Color)((Object)o)));
            }
            catch (InterruptedIOException x) {
                Thread.currentThread().interrupt();
            }
            catch (IOException x) {
                this.setError();
            }
        } else {
            this.print(o);
        }
        return this;
    }

    public final RenderPrintWriter cls() {
        try {
            this.out.provide(CLS.INSTANCE);
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.setError();
        }
        return this;
    }

    @Override
    public void println(Object x) {
        this.print(x);
        this.println();
    }

    public void show(Element element) {
        element.render(new RenderAppendable(this.out));
    }

    @Override
    public void print(Object obj) {
        if (obj instanceof UIBuilder) {
            RenderAppendable out = new RenderAppendable(this.out);
            new UIBuilderRenderable().renderer(Collections.singleton((UIBuilder)obj).iterator()).render(out);
        } else if (obj instanceof Element) {
            RenderAppendable out = new RenderAppendable(this.out);
            ((Element)obj).renderer().render(out);
        } else {
            super.print(obj);
        }
    }
}

