/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.vfs.spi.url;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.crsh.vfs.spi.AbstractFSDriver;
import org.crsh.vfs.spi.url.Node;

public class URLDriver
extends AbstractFSDriver<Node> {
    private final Node root = new Node();

    public void merge(ClassLoader loader) throws IOException, URISyntaxException {
        this.root.merge(loader);
    }

    public void merge(URL url) throws IOException, URISyntaxException {
        this.root.merge(url);
    }

    @Override
    public Node root() throws IOException {
        return this.root;
    }

    @Override
    public String name(Node handle) throws IOException {
        return handle.name;
    }

    @Override
    public boolean isDir(Node handle) throws IOException {
        return handle.files.isEmpty();
    }

    @Override
    public Iterable<Node> children(Node handle) throws IOException {
        return handle.children.values();
    }

    @Override
    public long getLastModified(Node handle) throws IOException {
        return handle.files.isEmpty() ? 0L : handle.files.peekFirst().lastModified;
    }

    @Override
    public Iterator<InputStream> open(Node handle) throws IOException {
        ArrayList<InputStream> list = new ArrayList<InputStream>(handle.files.size());
        for (Node.File file : handle.files) {
            list.add(file.resolver.open());
        }
        return list.iterator();
    }
}

