/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh.term;

import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyPair;
import org.apache.sshd.server.keyprovider.PEMGeneratorHostKeyProvider;
import org.crsh.util.Safe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRaSHPEMGeneratorHostKeyProvider
extends PEMGeneratorHostKeyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CRaSHPEMGeneratorHostKeyProvider.class);
    private URL url;
    private KeyPair[] keyPair;

    public CRaSHPEMGeneratorHostKeyProvider(String path, URL url) {
        super(path);
        this.url = url;
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL url) {
        this.url = url;
    }

    public synchronized KeyPair[] loadKeys() {
        KeyPair generated;
        KeyPair[] superKeyPair;
        if (this.keyPair == null && (superKeyPair = super.loadKeys()).length > 0) {
            this.keyPair = superKeyPair;
        }
        if (this.keyPair == null && this.url != null && (generated = this.readKeyPair(this.url)) != null) {
            this.keyPair = new KeyPair[]{generated};
        }
        if (this.keyPair == null) {
            this.keyPair = new KeyPair[0];
        }
        return (KeyPair[])this.keyPair.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyPair readKeyPair(URL url) {
        InputStream is = null;
        try {
            is = url.openStream();
            KeyPair keyPair = this.doReadKeyPair(is);
            return keyPair;
        }
        catch (Exception e) {
            LOG.info("Unable to read key {}: {}", (Object)url, (Object)e);
        }
        finally {
            Safe.close((Closeable)is);
        }
        return null;
    }
}

