/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh.term.scp;

import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.crsh.plugin.PluginContext;
import org.crsh.ssh.term.FailCommand;
import org.crsh.ssh.term.scp.CommandPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCPCommandFactory
implements CommandFactory {
    private static final Logger log = LoggerFactory.getLogger(SCPCommandFactory.class);
    private final PluginContext pluginContext;

    public SCPCommandFactory(PluginContext pluginContext) {
        this.pluginContext = pluginContext;
    }

    public Command createCommand(String command) {
        command = command.trim();
        log.debug("About to execute shell command " + command);
        for (CommandPlugin plugin : this.pluginContext.getPlugins(CommandPlugin.class)) {
            Command cmd = plugin.createCommand(command);
            if (cmd == null) continue;
            return cmd;
        }
        return new FailCommand("Unrecognized command " + command);
    }
}

