/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh.term;

import java.net.URL;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.Session;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.crsh.auth.AuthenticationPlugin;
import org.crsh.plugin.PluginContext;
import org.crsh.ssh.term.CRaSHCommandFactory;
import org.crsh.ssh.term.URLKeyPairProvider;
import org.crsh.ssh.term.scp.SCPCommandFactory;
import org.crsh.term.TermLifeCycle;
import org.crsh.term.spi.TermIOHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHLifeCycle
extends TermLifeCycle {
    public static final Session.AttributeKey<String> USERNAME = new Session.AttributeKey();
    public static final Session.AttributeKey<String> PASSWORD = new Session.AttributeKey();
    private final Logger log = LoggerFactory.getLogger(SSHLifeCycle.class);
    private SshServer server;
    private int port;
    private URL keyURL;
    private String authentication;

    public SSHLifeCycle(PluginContext context) {
        super(context);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public URL getKeyURL() {
        return this.keyURL;
    }

    public void setKeyURL(URL keyURL) {
        this.keyURL = keyURL;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(String authentication) {
        this.authentication = authentication;
    }

    protected void doInit() {
        try {
            TermIOHandler handler = this.getHandler();
            SshServer server = SshServer.setUpDefaultServer();
            server.setPort(this.port);
            server.setShellFactory((Factory)new CRaSHCommandFactory(handler));
            server.setCommandFactory((CommandFactory)new SCPCommandFactory(this.getContext()));
            server.setKeyPairProvider((KeyPairProvider)new URLKeyPairProvider(this.keyURL));
            AuthenticationPlugin plugin = new AuthenticationPlugin(){

                public String getName() {
                    return "null";
                }

                public boolean authenticate(String username, String password) throws Exception {
                    return false;
                }
            };
            if (this.authentication != null) {
                for (AuthenticationPlugin authenticationPlugin : this.getContext().getPlugins(AuthenticationPlugin.class)) {
                    if (!this.authentication.equals(authenticationPlugin.getName())) continue;
                    plugin = authenticationPlugin;
                    break;
                }
            }
            final AuthenticationPlugin authPlugin = plugin;
            server.setPasswordAuthenticator(new PasswordAuthenticator(){

                public boolean authenticate(String _username, String _password, ServerSession session) {
                    boolean auth;
                    if (authPlugin != null) {
                        try {
                            SSHLifeCycle.this.log.debug("Using authentication plugin " + authPlugin + " to authenticate user " + _username);
                            auth = authPlugin.authenticate(_username, _password);
                        }
                        catch (Exception e) {
                            SSHLifeCycle.this.log.error("Exception authenticating user " + _username + " in authentication plugin: " + authPlugin, (Throwable)e);
                            return false;
                        }
                    } else {
                        auth = true;
                    }
                    session.setAttribute(USERNAME, (Object)_username);
                    session.setAttribute(PASSWORD, (Object)_password);
                    return auth;
                }
            });
            this.log.info("About to start CRaSSHD");
            server.start();
            this.log.info("CRaSSHD started on port " + this.port);
            this.server = server;
        }
        catch (Throwable e) {
            this.log.error("Could not start CRaSSHD", e);
        }
    }

    protected void doDestroy() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (InterruptedException e) {
                this.log.debug("Got an interruption when stopping server", (Throwable)e);
            }
        }
    }
}

