/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.session;

import java.io.IOException;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.session.IoSession;
import org.apache.sshd.agent.AgentForwardSupport;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.KeyExchange;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.server.HandshakingUserAuth;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.UserAuth;
import org.apache.sshd.server.channel.OpenChannelException;
import org.apache.sshd.server.session.TcpipForwardSupport;
import org.apache.sshd.server.x11.X11ForwardSupport;

public class ServerSession
extends AbstractSession {
    private Future authTimerFuture;
    private Future idleTimerFuture;
    private State state = State.ReceiveKexInit;
    private int maxAuthRequests = this.getIntProperty("max-auth-requests", this.maxAuthRequests);
    private int nbAuthRequests;
    private int authTimeout = this.getIntProperty("auth-timeout", this.authTimeout);
    private int idleTimeout = this.getIntProperty("idle-timeout", this.idleTimeout);
    private boolean allowMoreSessions = true;
    private final TcpipForwardSupport tcpipForward = new TcpipForwardSupport(this);
    private final AgentForwardSupport agentForward = new AgentForwardSupport(this);
    private final X11ForwardSupport x11Forward = new X11ForwardSupport(this);
    private HandshakingUserAuth currentAuth;
    private List<NamedFactory<UserAuth>> userAuthFactories;

    public ServerSession(FactoryManager server, IoSession ioSession) throws Exception {
        super(server, ioSession);
        this.log.info("Session created...");
        this.sendServerIdentification();
        this.sendKexInit();
    }

    public CloseFuture close(boolean immediately) {
        this.unscheduleAuthTimer();
        this.unscheduleIdleTimer();
        this.tcpipForward.close();
        this.agentForward.close();
        this.x11Forward.close();
        return super.close(immediately);
    }

    public String getNegociated(int index) {
        return this.negociated[index];
    }

    public KeyExchange getKex() {
        return this.kex;
    }

    public byte[] getSessionId() {
        return this.sessionId;
    }

    public ServerFactoryManager getServerFactoryManager() {
        return (ServerFactoryManager)this.factoryManager;
    }

    protected ScheduledExecutorService getScheduledExecutorService() {
        return this.getServerFactoryManager().getScheduledExecutorService();
    }

    protected void handleMessage(Buffer buffer) throws Exception {
        SshConstants.Message cmd = buffer.getCommand();
        this.log.debug("Received packet {}", (Object)cmd);
        block0 : switch (cmd) {
            case SSH_MSG_DISCONNECT: {
                int code = buffer.getInt();
                String msg = buffer.getString();
                this.log.info("Received SSH_MSG_DISCONNECT (reason={}, msg={})", (Object)code, (Object)msg);
                this.close(true);
                break;
            }
            case SSH_MSG_UNIMPLEMENTED: {
                int code = buffer.getInt();
                this.log.info("Received SSH_MSG_UNIMPLEMENTED #{}", (Object)code);
                break;
            }
            case SSH_MSG_DEBUG: {
                boolean display = buffer.getBoolean();
                String msg = buffer.getString();
                this.log.info("Received SSH_MSG_DEBUG (display={}) '{}'", (Object)display, (Object)msg);
                break;
            }
            case SSH_MSG_IGNORE: {
                this.log.info("Received SSH_MSG_IGNORE");
                break;
            }
            default: {
                switch (this.state) {
                    case ReceiveKexInit: {
                        if (cmd != SshConstants.Message.SSH_MSG_KEXINIT) {
                            this.log.error("Ignoring command " + (Object)((Object)cmd) + " while waiting for " + (Object)((Object)SshConstants.Message.SSH_MSG_KEXINIT));
                            break block0;
                        }
                        this.log.info("Received SSH_MSG_KEXINIT");
                        this.receiveKexInit(buffer);
                        this.negociate();
                        this.kex = (KeyExchange)NamedFactory.Utils.create(this.factoryManager.getKeyExchangeFactories(), this.negociated[0]);
                        this.kex.init(this, this.serverVersion.getBytes(), this.clientVersion.getBytes(), this.I_S, this.I_C);
                        this.state = State.Kex;
                        break block0;
                    }
                    case Kex: {
                        buffer.rpos(buffer.rpos() - 1);
                        if (!this.kex.next(buffer)) break block0;
                        this.sendNewKeys();
                        this.state = State.ReceiveNewKeys;
                        break block0;
                    }
                    case ReceiveNewKeys: {
                        if (cmd != SshConstants.Message.SSH_MSG_NEWKEYS) {
                            this.disconnect(2, "Protocol error: expected packet " + (Object)((Object)SshConstants.Message.SSH_MSG_NEWKEYS) + ", got " + (Object)((Object)cmd));
                            return;
                        }
                        this.log.info("Received SSH_MSG_NEWKEYS");
                        this.receiveNewKeys(true);
                        this.state = State.WaitingUserAuth;
                        this.scheduleAuthTimer();
                        break block0;
                    }
                    case WaitingUserAuth: {
                        if (cmd != SshConstants.Message.SSH_MSG_SERVICE_REQUEST) {
                            this.log.info("Expecting a {}, but received {}", (Object)SshConstants.Message.SSH_MSG_SERVICE_REQUEST, (Object)cmd);
                            this.notImplemented();
                            break block0;
                        }
                        String request = buffer.getString();
                        this.log.info("Received SSH_MSG_SERVICE_REQUEST '{}'", (Object)request);
                        if ("ssh-userauth".equals(request)) {
                            this.userAuth(buffer, null);
                            break block0;
                        }
                        this.disconnect(7, "Bad service request: " + request);
                        break block0;
                    }
                    case UserAuth: {
                        if (!(cmd == SshConstants.Message.SSH_MSG_USERAUTH_REQUEST || this.currentAuth != null && this.currentAuth.handles(cmd))) {
                            this.disconnect(2, "Protocol error: expected packet " + (Object)((Object)SshConstants.Message.SSH_MSG_USERAUTH_REQUEST) + ", got " + (Object)((Object)cmd));
                            return;
                        }
                        this.log.info("Received " + (Object)((Object)cmd));
                        this.userAuth(buffer, cmd);
                        break block0;
                    }
                    case Running: {
                        this.unscheduleIdleTimer();
                        this.running(cmd, buffer);
                        this.scheduleIdleTimer();
                        break block0;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported state: " + (Object)((Object)this.state));
                    }
                }
            }
        }
    }

    private void running(SshConstants.Message cmd, Buffer buffer) throws Exception {
        switch (cmd) {
            case SSH_MSG_SERVICE_REQUEST: {
                this.serviceRequest(buffer);
                break;
            }
            case SSH_MSG_CHANNEL_OPEN: {
                this.channelOpen(buffer);
                break;
            }
            case SSH_MSG_CHANNEL_OPEN_CONFIRMATION: {
                this.channelOpenConfirmation(buffer);
                break;
            }
            case SSH_MSG_CHANNEL_OPEN_FAILURE: {
                this.channelOpenFailure(buffer);
                break;
            }
            case SSH_MSG_CHANNEL_REQUEST: {
                this.channelRequest(buffer);
                break;
            }
            case SSH_MSG_CHANNEL_DATA: {
                this.channelData(buffer);
                break;
            }
            case SSH_MSG_CHANNEL_EXTENDED_DATA: {
                this.channelExtendedData(buffer);
                break;
            }
            case SSH_MSG_CHANNEL_WINDOW_ADJUST: {
                this.channelWindowAdjust(buffer);
                break;
            }
            case SSH_MSG_CHANNEL_EOF: {
                this.channelEof(buffer);
                break;
            }
            case SSH_MSG_CHANNEL_CLOSE: {
                this.channelClose(buffer);
                break;
            }
            case SSH_MSG_GLOBAL_REQUEST: {
                this.globalRequest(buffer);
                break;
            }
            case SSH_MSG_KEXINIT: {
                this.receiveKexInit(buffer);
                this.sendKexInit();
                this.negociate();
                this.kex = (KeyExchange)NamedFactory.Utils.create(this.factoryManager.getKeyExchangeFactories(), this.negociated[0]);
                this.kex.init(this, this.serverVersion.getBytes(), this.clientVersion.getBytes(), this.I_S, this.I_C);
                break;
            }
            case SSH_MSG_KEXDH_INIT: {
                buffer.rpos(buffer.rpos() - 1);
                if (!this.kex.next(buffer)) break;
                this.sendNewKeys();
                break;
            }
            case SSH_MSG_NEWKEYS: {
                this.receiveNewKeys(true);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported command: " + (Object)((Object)cmd));
            }
        }
    }

    private void scheduleAuthTimer() {
        Runnable authTimerTask = new Runnable(){

            public void run() {
                try {
                    ServerSession.this.processAuthTimer();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        this.authTimerFuture = this.getScheduledExecutorService().schedule(authTimerTask, (long)this.authTimeout, TimeUnit.MILLISECONDS);
    }

    private void unscheduleAuthTimer() {
        if (this.authTimerFuture != null) {
            this.authTimerFuture.cancel(false);
            this.authTimerFuture = null;
        }
    }

    private void scheduleIdleTimer() {
        Runnable idleTimerTask = new Runnable(){

            public void run() {
                try {
                    ServerSession.this.processIdleTimer();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        this.idleTimerFuture = this.getScheduledExecutorService().schedule(idleTimerTask, (long)this.idleTimeout, TimeUnit.MILLISECONDS);
    }

    private void unscheduleIdleTimer() {
        if (this.idleTimerFuture != null) {
            this.idleTimerFuture.cancel(false);
            this.idleTimerFuture = null;
        }
    }

    private void processAuthTimer() throws IOException {
        if (!this.authed) {
            this.disconnect(2, "User authentication has timed out");
        }
    }

    private void processIdleTimer() throws IOException {
        this.disconnect(2, "User idle has timed out after " + this.idleTimeout + "ms.");
    }

    private void sendServerIdentification() {
        this.serverVersion = this.getFactoryManager().getProperties() != null && this.getFactoryManager().getProperties().get("server-identification") != null ? "SSH-2.0-" + this.getFactoryManager().getProperties().get("server-identification") : "SSH-2.0-" + this.getFactoryManager().getVersion();
        this.sendIdentification(this.serverVersion);
    }

    private void sendKexInit() throws IOException {
        this.serverProposal = this.createProposal(this.factoryManager.getKeyPairProvider().getKeyTypes());
        this.I_S = this.sendKexInit(this.serverProposal);
    }

    protected boolean readIdentification(Buffer buffer) throws IOException {
        this.clientVersion = this.doReadIdentification(buffer);
        if (this.clientVersion == null) {
            return false;
        }
        this.log.info("Client version string: {}", (Object)this.clientVersion);
        if (!this.clientVersion.startsWith("SSH-2.0-")) {
            throw new SshException(8, "Unsupported protocol version: " + this.clientVersion);
        }
        return true;
    }

    private void receiveKexInit(Buffer buffer) throws IOException {
        this.clientProposal = new String[10];
        this.I_C = this.receiveKexInit(buffer, this.clientProposal);
    }

    private void serviceRequest(Buffer buffer) throws Exception {
        String request = buffer.getString();
        this.log.info("Received SSH_MSG_SERVICE_REQUEST '{}'", (Object)request);
        this.disconnect(7, "Unsupported service request: " + request);
    }

    private void userAuth(Buffer buffer, SshConstants.Message cmd) throws Exception {
        if (this.state == State.WaitingUserAuth) {
            this.log.info("Accepting user authentication request");
            buffer = this.createBuffer(SshConstants.Message.SSH_MSG_SERVICE_ACCEPT, 0);
            buffer.putString("ssh-userauth");
            this.writePacket(buffer);
            this.userAuthFactories = new ArrayList<NamedFactory<UserAuth>>(this.getServerFactoryManager().getUserAuthFactories());
            this.log.info("Authorized authentication methods: {}", (Object)NamedFactory.Utils.getNames(this.userAuthFactories));
            this.state = State.UserAuth;
        } else {
            if (this.nbAuthRequests++ > this.maxAuthRequests) {
                throw new SshException(2, "Too may authentication failures");
            }
            Boolean authed = null;
            String username = null;
            if (cmd == SshConstants.Message.SSH_MSG_USERAUTH_REQUEST) {
                username = buffer.getString();
                String svcName = buffer.getString();
                String method = buffer.getString();
                this.log.info("Authenticating user '{}' with method '{}'", (Object)username, (Object)method);
                NamedFactory factory = NamedFactory.Utils.get(this.userAuthFactories, method);
                if (factory != null) {
                    UserAuth auth = (UserAuth)factory.create();
                    try {
                        authed = auth.auth(this, username, buffer);
                        if (authed == null) {
                            this.log.info("Authentication not finished");
                            if (auth instanceof HandshakingUserAuth) {
                                this.currentAuth = (HandshakingUserAuth)auth;
                                this.currentAuth.setServiceName(svcName);
                            }
                            return;
                        }
                        this.log.info(authed != false ? "Authentication succeeded" : "Authentication failed");
                    }
                    catch (Exception e) {
                        authed = false;
                        this.log.info("Authentication failed: {}", (Object)e.getMessage());
                    }
                } else {
                    this.log.info("Unsupported authentication method '{}'", (Object)method);
                }
            } else {
                try {
                    authed = this.currentAuth.next(this, cmd, buffer);
                    if (authed == null) {
                        this.log.info("Authentication still not finished");
                        return;
                    }
                    if (authed.booleanValue()) {
                        username = this.currentAuth.getUserName();
                    }
                }
                catch (Exception e) {
                    authed = false;
                    this.log.info("Authentication next failed: {}", (Object)e.getMessage());
                }
            }
            if (this.currentAuth != null) {
                this.currentAuth.destroy();
                this.currentAuth = null;
            }
            if (authed != null && authed.booleanValue()) {
                String maxSessionCountAsString;
                if (this.getFactoryManager().getProperties() != null && (maxSessionCountAsString = this.getFactoryManager().getProperties().get("max-concurrent-sessions")) != null) {
                    int maxSessionCount = Integer.parseInt(maxSessionCountAsString);
                    int currentSessionCount = this.getActiveSessionCountForUser(username);
                    if (currentSessionCount >= maxSessionCount) {
                        this.disconnect(7, "Too many concurrent connections");
                        return;
                    }
                }
                buffer = this.createBuffer(SshConstants.Message.SSH_MSG_USERAUTH_SUCCESS, 0);
                this.writePacket(buffer);
                this.state = State.Running;
                this.authed = true;
                this.username = username;
                this.unscheduleAuthTimer();
            } else {
                buffer = this.createBuffer(SshConstants.Message.SSH_MSG_USERAUTH_FAILURE, 0);
                NamedFactory.Utils.remove(this.userAuthFactories, "none");
                buffer.putString(NamedFactory.Utils.getNames(this.userAuthFactories));
                buffer.putByte((byte)0);
                this.writePacket(buffer);
            }
        }
    }

    public KeyPair getHostKey() {
        return this.factoryManager.getKeyPairProvider().loadKey(this.negociated[1]);
    }

    protected int getActiveSessionCountForUser(String userName) {
        int totalCount = 0;
        for (IoSession is : this.ioSession.getService().getManagedSessions().values()) {
            ServerSession session = (ServerSession)ServerSession.getSession(is, true);
            if (session == null || session.getUsername() == null || !session.getUsername().equals(userName)) continue;
            ++totalCount;
        }
        return totalCount;
    }

    private void channelOpen(Buffer buffer) throws Exception {
        String type = buffer.getString();
        final int id = buffer.getInt();
        int rwsize = buffer.getInt();
        int rmpsize = buffer.getInt();
        this.log.info("Received SSH_MSG_CHANNEL_OPEN {}", (Object)type);
        if (this.closing) {
            Buffer buf = this.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_OPEN_FAILURE, 0);
            buf.putInt(id);
            buf.putInt(2L);
            buf.putString("SSH server is shutting down: " + type);
            buf.putString("");
            this.writePacket(buf);
            return;
        }
        if (!this.allowMoreSessions) {
            Buffer buf = this.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_OPEN_FAILURE, 0);
            buf.putInt(id);
            buf.putInt(2L);
            buf.putString("additional sessions disabled");
            buf.putString("");
            this.writePacket(buf);
            return;
        }
        final Channel channel = (Channel)NamedFactory.Utils.create(this.getServerFactoryManager().getChannelFactories(), type);
        if (channel == null) {
            Buffer buf = this.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_OPEN_FAILURE, 0);
            buf.putInt(id);
            buf.putInt(3L);
            buf.putString("Unsupported channel type: " + type);
            buf.putString("");
            this.writePacket(buf);
            return;
        }
        final int channelId = this.getNextChannelId();
        this.channels.put(channelId, channel);
        channel.init(this, channelId);
        channel.open(id, rwsize, rmpsize, buffer).addListener(new SshFutureListener<OpenFuture>(){

            @Override
            public void operationComplete(OpenFuture future) {
                try {
                    if (future.isOpened()) {
                        Buffer buf = ServerSession.this.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_OPEN_CONFIRMATION, 0);
                        buf.putInt(id);
                        buf.putInt(channelId);
                        buf.putInt(channel.getLocalWindow().getSize());
                        buf.putInt(channel.getLocalWindow().getPacketSize());
                        ServerSession.this.writePacket(buf);
                    } else if (future.getException() != null) {
                        Buffer buf = ServerSession.this.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_OPEN_FAILURE, 0);
                        buf.putInt(id);
                        if (future.getException() instanceof OpenChannelException) {
                            buf.putInt(((OpenChannelException)future.getException()).getReasonCode());
                            buf.putString(future.getException().getMessage());
                        } else {
                            buf.putInt(0L);
                            buf.putString("Error opening channel: " + future.getException().getMessage());
                        }
                        buf.putString("");
                        ServerSession.this.writePacket(buf);
                    }
                }
                catch (IOException e) {
                    ServerSession.this.exceptionCaught(e);
                }
            }
        });
    }

    private void globalRequest(Buffer buffer) throws Exception {
        String req = buffer.getString();
        boolean wantReply = buffer.getBoolean();
        if (!req.startsWith("keepalive@")) {
            if (req.equals("no-more-sessions@openssh.com")) {
                this.allowMoreSessions = false;
            } else {
                if (req.equals("tcpip-forward")) {
                    this.tcpipForward.request(buffer, wantReply);
                    return;
                }
                if (req.equals("cancel-tcpip-forward")) {
                    this.tcpipForward.cancel(buffer, wantReply);
                    return;
                }
                this.log.info("Received SSH_MSG_GLOBAL_REQUEST {}", (Object)req);
                this.log.warn("Unknown global request: {}", (Object)req);
            }
        }
        if (wantReply) {
            buffer = this.createBuffer(SshConstants.Message.SSH_MSG_REQUEST_FAILURE, 0);
            this.writePacket(buffer);
        }
    }

    public String initAgentForward() throws IOException {
        return this.agentForward.initialize();
    }

    public String createX11Display(boolean singleConnection, String authenticationProtocol, String authenticationCookie, int screen) throws IOException {
        return this.x11Forward.createDisplay(singleConnection, authenticationProtocol, authenticationCookie, screen);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        ReceiveKexInit,
        Kex,
        ReceiveNewKeys,
        WaitingUserAuth,
        UserAuth,
        Running,
        Unknown;

    }
}

