/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.telnet.term;

import java.io.ByteArrayInputStream;
import java.util.Properties;
import net.wimpi.telnetd.TelnetD;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.ResourceKind;
import org.crsh.term.CRaSHLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelnetLifeCycle
extends CRaSHLifeCycle {
    private final Logger log = LoggerFactory.getLogger(TelnetLifeCycle.class);
    private TelnetD daemon;
    static TelnetLifeCycle instance;
    private Integer port;

    public TelnetLifeCycle(PluginContext context) {
        super(context);
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    protected synchronized void doInit() throws Exception {
        if (instance != null) {
            throw new IllegalStateException("An instance already exists");
        }
        String s = this.getShellContext().loadResource("telnet.properties", ResourceKind.CONFIG).getContent();
        Properties props = new Properties();
        props.load(new ByteArrayInputStream(s.getBytes("ISO-8859-1")));
        if (this.port != null) {
            this.log.debug("Explicit telnet port configuration with value " + this.port);
            props.put("std.port", this.port.toString());
        } else {
            this.log.debug("Use default telnet port configuration " + props.getProperty("std.port"));
        }
        TelnetD daemon = TelnetD.createTelnetD((Properties)props);
        daemon.start();
        this.daemon = daemon;
        instance = this;
    }

    protected synchronized void doDestroy() {
        instance = null;
        if (this.daemon != null) {
            this.daemon.stop();
            this.daemon = null;
        }
    }
}

