/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.telnet.term;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.net.telnet.TelnetClient;
import org.crsh.TestPluginContext;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PluginDiscovery;
import org.crsh.plugin.SimplePluginDiscovery;
import org.crsh.telnet.TelnetPlugin;
import org.crsh.term.IOHandler;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;

@RunWith(value=BMUnitRunner.class)
public abstract class AbstractTelnetTestCase
extends Assert {
    protected TestPluginContext ctx;
    protected TelnetClient client;
    protected OutputStream out;
    protected InputStream in;
    protected IOHandler handler;
    private boolean running;
    private static final AtomicInteger PORTS = new AtomicInteger(5000);

    @Before
    public final void setUp() throws Exception {
        int port = PORTS.getAndIncrement();
        IOHandler handler = new IOHandler();
        SimplePluginDiscovery discovery = new SimplePluginDiscovery();
        discovery.add((CRaSHPlugin)new TelnetPlugin());
        discovery.add((CRaSHPlugin)handler);
        this.ctx = new TestPluginContext((PluginDiscovery)discovery);
        this.ctx.setProperty(TelnetPlugin.TELNET_PORT, (Object)port);
        this.ctx.start();
        TelnetClient client = new TelnetClient();
        client.connect("localhost", port);
        this.out = client.getOutputStream();
        this.in = client.getInputStream();
        this.handler = handler;
        this.client = client;
        this.running = true;
    }

    @After
    public final void tearDown() throws Exception {
        this.stop();
    }

    protected final void stop() {
        if (this.running) {
            this.ctx.stop();
            this.running = false;
        }
    }
}

