/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import com.google.common.base.Strings;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.cryptomator.cryptofs.event.FilesystemEvent;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.MasterkeyLoader;

public class CryptoFileSystemProperties
extends AbstractMap<String, Object> {
    public static final String PROPERTY_MAX_CLEARTEXT_NAME_LENGTH = "maxCleartextNameLength";
    static final int DEFAULT_MAX_CLEARTEXT_NAME_LENGTH = 10240;
    public static final String PROPERTY_SHORTENING_THRESHOLD = "shorteningThreshold";
    static final int DEFAULT_SHORTENING_THRESHOLD = 220;
    public static final String PROPERTY_KEYLOADER = "keyLoader";
    public static final String PROPERTY_VAULTCONFIG_FILENAME = "vaultConfigFilename";
    static final String DEFAULT_VAULTCONFIG_FILENAME = "vault.cryptomator";
    @Deprecated
    public static final String PROPERTY_MASTERKEY_FILENAME = "masterkeyFilename";
    static final String DEFAULT_MASTERKEY_FILENAME = "masterkey.cryptomator";
    public static final String PROPERTY_EVENT_CONSUMER = "fsEventConsumer";
    static final Consumer<FilesystemEvent> DEFAULT_EVENT_CONSUMER = ignored -> {};
    public static final String PROPERTY_FILESYSTEM_FLAGS = "flags";
    static final Set<FileSystemFlags> DEFAULT_FILESYSTEM_FLAGS = EnumSet.noneOf(FileSystemFlags.class);
    public static final String PROPERTY_CIPHER_COMBO = "cipherCombo";
    static final CryptorProvider.Scheme DEFAULT_CIPHER_COMBO = CryptorProvider.Scheme.SIV_GCM;
    private final Set<Map.Entry<String, Object>> entries;

    private CryptoFileSystemProperties(Builder builder) {
        this.entries = Set.of(Map.entry(PROPERTY_KEYLOADER, builder.keyLoader), Map.entry(PROPERTY_FILESYSTEM_FLAGS, builder.flags), Map.entry(PROPERTY_VAULTCONFIG_FILENAME, builder.vaultConfigFilename), Map.entry(PROPERTY_MASTERKEY_FILENAME, builder.masterkeyFilename), Map.entry(PROPERTY_EVENT_CONSUMER, builder.eventConsumer), Map.entry(PROPERTY_MAX_CLEARTEXT_NAME_LENGTH, builder.maxCleartextNameLength), Map.entry(PROPERTY_SHORTENING_THRESHOLD, builder.shorteningThreshold), Map.entry(PROPERTY_CIPHER_COMBO, builder.cipherCombo));
    }

    MasterkeyLoader keyLoader() {
        return (MasterkeyLoader)this.get(PROPERTY_KEYLOADER);
    }

    public CryptorProvider.Scheme cipherCombo() {
        return (CryptorProvider.Scheme)this.get(PROPERTY_CIPHER_COMBO);
    }

    public Set<FileSystemFlags> flags() {
        return (Set)this.get(PROPERTY_FILESYSTEM_FLAGS);
    }

    public boolean readonly() {
        return this.flags().contains((Object)FileSystemFlags.READONLY);
    }

    String vaultConfigFilename() {
        return (String)this.get(PROPERTY_VAULTCONFIG_FILENAME);
    }

    @Deprecated
    String masterkeyFilename() {
        return (String)this.get(PROPERTY_MASTERKEY_FILENAME);
    }

    int maxCleartextNameLength() {
        return (Integer)this.get(PROPERTY_MAX_CLEARTEXT_NAME_LENGTH);
    }

    int shorteningThreshold() {
        return (Integer)this.get(PROPERTY_SHORTENING_THRESHOLD);
    }

    Consumer<FilesystemEvent> filesystemEventConsumer() {
        return (Consumer)this.get(PROPERTY_EVENT_CONSUMER);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.entries;
    }

    public static Builder cryptoFileSystemProperties() {
        return new Builder();
    }

    public static Builder cryptoFileSystemPropertiesFrom(Map<String, ?> properties) {
        return new Builder(properties);
    }

    public static CryptoFileSystemProperties wrap(Map<String, ?> properties) {
        if (properties instanceof CryptoFileSystemProperties) {
            CryptoFileSystemProperties p = (CryptoFileSystemProperties)properties;
            return p;
        }
        try {
            return CryptoFileSystemProperties.cryptoFileSystemPropertiesFrom(properties).build();
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static class Builder {
        public CryptorProvider.Scheme cipherCombo = DEFAULT_CIPHER_COMBO;
        private MasterkeyLoader keyLoader = null;
        private final Set<FileSystemFlags> flags = EnumSet.copyOf(DEFAULT_FILESYSTEM_FLAGS);
        private String vaultConfigFilename = "vault.cryptomator";
        private String masterkeyFilename = "masterkey.cryptomator";
        private int maxCleartextNameLength = 10240;
        private int shorteningThreshold = 220;
        private Consumer<FilesystemEvent> eventConsumer = DEFAULT_EVENT_CONSUMER;

        private Builder() {
        }

        private Builder(Map<String, ?> properties) {
            this.checkedSet(MasterkeyLoader.class, CryptoFileSystemProperties.PROPERTY_KEYLOADER, properties, this::withKeyLoader);
            this.checkedSet(String.class, CryptoFileSystemProperties.PROPERTY_VAULTCONFIG_FILENAME, properties, this::withVaultConfigFilename);
            this.checkedSet(String.class, CryptoFileSystemProperties.PROPERTY_MASTERKEY_FILENAME, properties, this::withMasterkeyFilename);
            this.checkedSet(Set.class, CryptoFileSystemProperties.PROPERTY_FILESYSTEM_FLAGS, properties, this::withFlags);
            this.checkedSet(Integer.class, CryptoFileSystemProperties.PROPERTY_MAX_CLEARTEXT_NAME_LENGTH, properties, this::withMaxCleartextNameLength);
            this.checkedSet(Integer.class, CryptoFileSystemProperties.PROPERTY_SHORTENING_THRESHOLD, properties, this::withShorteningThreshold);
            this.checkedSet(CryptorProvider.Scheme.class, CryptoFileSystemProperties.PROPERTY_CIPHER_COMBO, properties, this::withCipherCombo);
            this.checkedSet(Consumer.class, CryptoFileSystemProperties.PROPERTY_EVENT_CONSUMER, properties, this::withFilesystemEventConsumer);
        }

        private <T> void checkedSet(Class<T> type, String key, Map<String, ?> properties, Consumer<T> setter) {
            Object value = properties.get(key);
            if (value == null) {
                return;
            }
            if (!type.isInstance(value)) {
                throw new IllegalArgumentException(key + " must be of type " + type.getSimpleName());
            }
            setter.accept(type.cast(value));
        }

        public Builder withMaxCleartextNameLength(int maxCleartextNameLength) {
            this.maxCleartextNameLength = maxCleartextNameLength;
            return this;
        }

        public Builder withShorteningThreshold(int shorteningThreshold) {
            this.shorteningThreshold = shorteningThreshold;
            return this;
        }

        public Builder withCipherCombo(CryptorProvider.Scheme cipherCombo) {
            this.cipherCombo = cipherCombo;
            return this;
        }

        public Builder withKeyLoader(MasterkeyLoader keyLoader) {
            this.keyLoader = keyLoader;
            return this;
        }

        public Builder withFlags(FileSystemFlags ... flags) {
            return this.withFlags(Arrays.asList(flags));
        }

        public Builder withFlags(Collection<FileSystemFlags> flags) {
            this.flags.clear();
            this.flags.addAll(flags);
            return this;
        }

        public Builder withVaultConfigFilename(String vaultConfigFilename) {
            this.vaultConfigFilename = vaultConfigFilename;
            return this;
        }

        @Deprecated
        public Builder withMasterkeyFilename(String masterkeyFilename) {
            this.masterkeyFilename = masterkeyFilename;
            return this;
        }

        public Builder withFilesystemEventConsumer(Consumer<FilesystemEvent> eventConsumer) {
            if (eventConsumer == null) {
                throw new IllegalArgumentException("Parameter eventConsumer must not be null");
            }
            this.eventConsumer = eventConsumer;
            return this;
        }

        public CryptoFileSystemProperties build() {
            this.validate();
            return new CryptoFileSystemProperties(this);
        }

        private void validate() {
            if (this.keyLoader == null) {
                throw new IllegalStateException("keyLoader is required");
            }
            if (Strings.nullToEmpty((String)this.masterkeyFilename).trim().isEmpty()) {
                throw new IllegalStateException("masterkeyFilename is required");
            }
        }
    }

    public static enum FileSystemFlags {
        READONLY;

    }
}

