/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.net.URI;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.cryptomator.cryptofs.CiphertextDirectory;
import org.cryptomator.cryptofs.CopyOperation;
import org.cryptomator.cryptofs.CryptoFileSystem;
import org.cryptomator.cryptofs.CryptoFileSystemImpl;
import org.cryptomator.cryptofs.CryptoFileSystemProperties;
import org.cryptomator.cryptofs.CryptoFileSystemProviderComponent;
import org.cryptomator.cryptofs.CryptoFileSystemUri;
import org.cryptomator.cryptofs.CryptoFileSystems;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.DaggerCryptoFileSystemProviderComponent;
import org.cryptomator.cryptofs.DirStructure;
import org.cryptomator.cryptofs.DirectoryIdBackup;
import org.cryptomator.cryptofs.FileSystemNeedsMigrationException;
import org.cryptomator.cryptofs.MoveOperation;
import org.cryptomator.cryptofs.VaultConfig;
import org.cryptomator.cryptofs.ch.AsyncDelegatingFileChannel;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.cryptolib.api.MasterkeyLoadingFailedException;

public class CryptoFileSystemProvider
extends FileSystemProvider {
    private final CryptoFileSystems fileSystems;
    private final MoveOperation moveOperation;
    private final CopyOperation copyOperation;

    public CryptoFileSystemProvider() {
        this(DaggerCryptoFileSystemProviderComponent.builder().csprng(CryptoFileSystemProvider.strongSecureRandom()).build());
    }

    private static SecureRandom strongSecureRandom() {
        try {
            return SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("A strong algorithm must exist in every Java platform.", e);
        }
    }

    CryptoFileSystemProvider(CryptoFileSystemProviderComponent component) {
        this.fileSystems = component.fileSystems();
        this.moveOperation = component.moveOperation();
        this.copyOperation = component.copyOperation();
    }

    public static CryptoFileSystem newFileSystem(Path pathToVault, CryptoFileSystemProperties properties) throws FileSystemNeedsMigrationException, IOException, MasterkeyLoadingFailedException {
        URI uri = CryptoFileSystemUri.create(pathToVault.toAbsolutePath(), new String[0]);
        return (CryptoFileSystem)FileSystems.newFileSystem(uri, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Path pathToVault, CryptoFileSystemProperties properties, URI keyId) throws NotDirectoryException, IOException, MasterkeyLoadingFailedException {
        if (!Files.isDirectory(pathToVault, new LinkOption[0])) {
            throw new NotDirectoryException(pathToVault.toString());
        }
        byte[] rawKey = new byte[]{};
        VaultConfig config = VaultConfig.createNew().cipherCombo(properties.cipherCombo()).shorteningThreshold(properties.shorteningThreshold()).build();
        try (Masterkey key = properties.keyLoader().loadKey(keyId);
             Cryptor cryptor = CryptorProvider.forScheme((CryptorProvider.Scheme)config.getCipherCombo()).provide(key, CryptoFileSystemProvider.strongSecureRandom());){
            rawKey = key.getEncoded();
            Path vaultConfigPath = pathToVault.resolve(properties.vaultConfigFilename());
            String token = config.toToken(keyId.toString(), rawKey);
            Files.writeString(vaultConfigPath, (CharSequence)token, StandardCharsets.US_ASCII, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
            String dirHash = cryptor.fileNameCryptor().hashDirectoryId("");
            Path vaultCipherRootPath = pathToVault.resolve("d").resolve(dirHash.substring(0, 2)).resolve(dirHash.substring(2));
            Files.createDirectories(vaultCipherRootPath, new FileAttribute[0]);
            DirectoryIdBackup.write(cryptor, new CiphertextDirectory("", vaultCipherRootPath));
        }
        finally {
            Arrays.fill(rawKey, (byte)0);
        }
        assert (CryptoFileSystemProvider.checkDirStructureForVault(pathToVault, properties.vaultConfigFilename(), null) == DirStructure.VAULT);
    }

    public static DirStructure checkDirStructureForVault(Path pathToAssumedVault, String vaultConfigFilename, String masterkeyFilename) throws IOException {
        return DirStructure.checkDirStructure(pathToAssumedVault, vaultConfigFilename, masterkeyFilename);
    }

    @Deprecated
    CryptoFileSystems getCryptoFileSystems() {
        return this.fileSystems;
    }

    @Override
    public String getScheme() {
        return "cryptomator";
    }

    @Override
    public CryptoFileSystem newFileSystem(URI uri, Map<String, ?> rawProperties) throws IOException, MasterkeyLoadingFailedException {
        CryptoFileSystemUri parsedUri = CryptoFileSystemUri.parse(uri);
        CryptoFileSystemProperties properties = CryptoFileSystemProperties.wrap(rawProperties);
        return this.fileSystems.create(this, parsedUri.pathToVault(), properties);
    }

    @Override
    public CryptoFileSystem getFileSystem(URI uri) {
        CryptoFileSystemUri parsedUri = CryptoFileSystemUri.parse(uri);
        return this.fileSystems.get(parsedUri.pathToVault());
    }

    @Override
    public Path getPath(URI uri) {
        CryptoFileSystemUri parsedUri = CryptoFileSystemUri.parse(uri);
        return this.fileSystems.get(parsedUri.pathToVault()).getPath(parsedUri.pathInsideVault(), new String[0]);
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path cleartextPath, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IOException {
        if (options.contains(StandardOpenOption.APPEND)) {
            throw new IllegalArgumentException("AsynchronousFileChannel can not be opened in append mode");
        }
        return new AsyncDelegatingFileChannel(this.newFileChannel(cleartextPath, options, attrs), executor);
    }

    @Override
    public FileChannel newFileChannel(Path cleartextPath, Set<? extends OpenOption> optionsSet, FileAttribute<?> ... attrs) throws IOException {
        return this.fileSystem(cleartextPath).newFileChannel(CryptoPath.castAndAssertAbsolute(cleartextPath), optionsSet, attrs);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path cleartextPath, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.newFileChannel(cleartextPath, options, attrs);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path cleartextDir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return this.fileSystem(cleartextDir).newDirectoryStream(CryptoPath.castAndAssertAbsolute(cleartextDir), filter);
    }

    @Override
    public void createDirectory(Path cleartextDir, FileAttribute<?> ... attrs) throws IOException {
        this.fileSystem(cleartextDir).createDirectory(CryptoPath.castAndAssertAbsolute(cleartextDir), attrs);
    }

    @Override
    public void delete(Path cleartextPath) throws IOException {
        this.fileSystem(cleartextPath).delete(CryptoPath.castAndAssertAbsolute(cleartextPath));
    }

    @Override
    public void copy(Path cleartextSource, Path cleartextTarget, CopyOption ... options) throws IOException {
        this.assertSameProvider(cleartextSource);
        this.assertSameProvider(cleartextTarget);
        this.copyOperation.copy(CryptoPath.castAndAssertAbsolute(cleartextSource), CryptoPath.castAndAssertAbsolute(cleartextTarget), options);
    }

    @Override
    public void move(Path cleartextSource, Path cleartextTarget, CopyOption ... options) throws IOException {
        this.assertSameProvider(cleartextSource);
        this.assertSameProvider(cleartextTarget);
        this.moveOperation.move(CryptoPath.castAndAssertAbsolute(cleartextSource), CryptoPath.castAndAssertAbsolute(cleartextTarget), options);
    }

    @Override
    public boolean isSameFile(Path cleartextPath, Path cleartextPath2) throws IOException {
        return cleartextPath.getFileSystem() == cleartextPath2.getFileSystem() && cleartextPath.toRealPath(new LinkOption[0]).equals(cleartextPath2.toRealPath(new LinkOption[0]));
    }

    @Override
    public boolean isHidden(Path cleartextPath) throws IOException {
        return this.fileSystem(cleartextPath).isHidden(CryptoPath.castAndAssertAbsolute(cleartextPath));
    }

    @Override
    public FileStore getFileStore(Path cleartextPath) {
        return this.fileSystem(cleartextPath).getFileStore();
    }

    @Override
    public void checkAccess(Path cleartextPath, AccessMode ... modes) throws IOException {
        this.fileSystem(cleartextPath).checkAccess(CryptoPath.castAndAssertAbsolute(cleartextPath), modes);
    }

    @Override
    public void createSymbolicLink(Path cleartextPath, Path target, FileAttribute<?> ... attrs) throws IOException {
        this.fileSystem(cleartextPath).createSymbolicLink(CryptoPath.castAndAssertAbsolute(cleartextPath), target, attrs);
    }

    @Override
    public Path readSymbolicLink(Path cleartextPath) throws IOException {
        return this.fileSystem(cleartextPath).readSymbolicLink(CryptoPath.castAndAssertAbsolute(cleartextPath));
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path cleartextPath, Class<V> type, LinkOption ... options) {
        return this.fileSystem(cleartextPath).getFileAttributeView(CryptoPath.castAndAssertAbsolute(cleartextPath), type, options);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path cleartextPath, Class<A> type, LinkOption ... options) throws IOException {
        return this.fileSystem(cleartextPath).readAttributes(CryptoPath.castAndAssertAbsolute(cleartextPath), type, options);
    }

    @Override
    public Map<String, Object> readAttributes(Path cleartextPath, String attributes, LinkOption ... options) throws IOException {
        return this.fileSystem(cleartextPath).readAttributes(CryptoPath.castAndAssertAbsolute(cleartextPath), attributes, options);
    }

    @Override
    public void setAttribute(Path cleartextPath, String attribute, Object value, LinkOption ... options) throws IOException {
        this.fileSystem(cleartextPath).setAttribute(CryptoPath.castAndAssertAbsolute(cleartextPath), attribute, value, options);
    }

    private CryptoFileSystemImpl fileSystem(Path path) {
        this.assertSameProvider(path);
        CryptoFileSystemImpl fs = CryptoPath.cast(path).getFileSystem();
        fs.assertOpen();
        return fs;
    }

    private void assertSameProvider(Path path) {
        if (path.getFileSystem().provider() != this) {
            throw new ProviderMismatchException("Used a path from provider " + String.valueOf(path.getFileSystem().provider()) + " with provider " + String.valueOf(this));
        }
    }
}

