/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.attr;

import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Set;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.CryptoPathMapper;
import org.cryptomator.cryptofs.ReadonlyFlag;
import org.cryptomator.cryptofs.Symlinks;
import org.cryptomator.cryptofs.attr.AttributeProvider;
import org.cryptomator.cryptofs.attr.AttributeViewScoped;
import org.cryptomator.cryptofs.attr.CryptoBasicFileAttributeView;
import org.cryptomator.cryptofs.fh.OpenCryptoFiles;

@AttributeViewScoped
final class CryptoPosixFileAttributeView
extends CryptoBasicFileAttributeView
implements PosixFileAttributeView {
    @Inject
    public CryptoPosixFileAttributeView(CryptoPath cleartextPath, CryptoPathMapper pathMapper, LinkOption[] linkOptions, Symlinks symlinks, OpenCryptoFiles openCryptoFiles, AttributeProvider fileAttributeProvider, ReadonlyFlag readonlyFlag) {
        super(cleartextPath, pathMapper, linkOptions, symlinks, openCryptoFiles, fileAttributeProvider, readonlyFlag);
    }

    @Override
    public String name() {
        return "posix";
    }

    @Override
    public PosixFileAttributes readAttributes() throws IOException {
        return this.fileAttributeProvider.readAttributes(this.cleartextPath, PosixFileAttributes.class, this.linkOptions);
    }

    @Override
    public UserPrincipal getOwner() throws IOException {
        return this.getCiphertextAttributeView(PosixFileAttributeView.class).getOwner();
    }

    @Override
    public void setOwner(UserPrincipal owner) throws IOException {
        this.readonlyFlag.assertWritable();
        this.getCiphertextAttributeView(PosixFileAttributeView.class).setOwner(owner);
    }

    @Override
    public void setPermissions(Set<PosixFilePermission> perms) throws IOException {
        this.readonlyFlag.assertWritable();
        this.getCiphertextAttributeView(PosixFileAttributeView.class).setPermissions(perms);
    }

    @Override
    public void setGroup(GroupPrincipal group) throws IOException {
        this.readonlyFlag.assertWritable();
        this.getCiphertextAttributeView(PosixFileAttributeView.class).setGroup(group);
    }
}

