/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.dir;

import jakarta.inject.Inject;
import java.util.stream.Stream;
import org.cryptomator.cryptofs.dir.C9rConflictResolver;
import org.cryptomator.cryptofs.dir.C9rDecryptor;
import org.cryptomator.cryptofs.dir.DirectoryStreamScoped;
import org.cryptomator.cryptofs.dir.Node;

@DirectoryStreamScoped
class C9rProcessor {
    private final C9rDecryptor decryptor;
    private final C9rConflictResolver conflictResolver;

    @Inject
    public C9rProcessor(C9rDecryptor decryptor, C9rConflictResolver conflictResolver) {
        this.decryptor = decryptor;
        this.conflictResolver = conflictResolver;
    }

    public Stream<Node> process(Node node) {
        assert (node.fullCiphertextFileName.endsWith(".c9r"));
        return this.decryptor.process(node).flatMap(this.conflictResolver::process);
    }
}

