/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.health.shortened;

import java.nio.file.Path;
import java.util.Map;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;

public class NotDecodableLongName
implements DiagnosticResult {
    private final Path nameFile;
    private final String longName;

    public NotDecodableLongName(Path nameFile, String longName) {
        this.nameFile = nameFile;
        this.longName = longName;
    }

    @Override
    public DiagnosticResult.Severity getSeverity() {
        return DiagnosticResult.Severity.CRITICAL;
    }

    @Override
    public Map<String, String> details() {
        return Map.of("Encrypted Path", this.nameFile.toString(), "Stored String", this.longName);
    }

    @Override
    public String toString() {
        return String.format("String \"%s\" stored in %s is not a valid Cryptomator filename.", this.longName, this.nameFile);
    }
}

