/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.integrations.common;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClassLoaderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ClassLoaderFactory.class);
    private static final String USER_HOME = System.getProperty("user.home");
    private static final String PLUGIN_DIR_KEY = "cryptomator.pluginDir";
    private static final String JAR_SUFFIX = ".jar";

    ClassLoaderFactory() {
    }

    @Contract(value="-> new", pure=true)
    public static URLClassLoader forPluginDir() {
        String val = System.getProperty(PLUGIN_DIR_KEY, "");
        Path p = val.startsWith("~/") ? Path.of(USER_HOME, new String[0]).resolve(val.substring(2)) : Path.of(val, new String[0]);
        return ClassLoaderFactory.forPluginDirWithPath(p);
    }

    @VisibleForTesting
    @Contract(value="_ -> new", pure=true)
    static URLClassLoader forPluginDirWithPath(Path path) throws UncheckedIOException {
        URL[] jars = ClassLoaderFactory.findJars(path);
        if (LOG.isDebugEnabled()) {
            String jarList = Arrays.stream(jars).map(URL::getPath).collect(Collectors.joining(", "));
            LOG.debug("Found jars in cryptomator.pluginDir: {}", (Object)jarList);
        }
        return URLClassLoader.newInstance(jars);
    }

    @VisibleForTesting
    static URL[] findJars(Path path) {
        URL[] uRLArray;
        block8: {
            Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);
            try {
                uRLArray = (URL[])stream.filter(ClassLoaderFactory::isJarFile).map(ClassLoaderFactory::toUrl).toArray(URL[]::new);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | UncheckedIOException e) {
                    return new URL[0];
                }
            }
            stream.close();
        }
        return uRLArray;
    }

    private static URL toUrl(Path path) throws UncheckedIOException {
        try {
            return path.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static boolean isJarFile(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().toLowerCase().endsWith(JAR_SUFFIX);
    }
}

