/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.integrations.common;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import org.cryptomator.integrations.common.CheckAvailability;
import org.cryptomator.integrations.common.ClassLoaderFactory;
import org.cryptomator.integrations.common.OperatingSystem;
import org.cryptomator.integrations.common.Priority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrationsLoader {
    private static final Logger LOG = LoggerFactory.getLogger(IntegrationsLoader.class);

    private IntegrationsLoader() {
    }

    public static <T> Optional<T> load(Class<T> clazz) {
        return IntegrationsLoader.loadAll(clazz).findFirst();
    }

    public static <T> Stream<T> loadAll(Class<T> clazz) {
        return IntegrationsLoader.loadAll(ServiceLoader.load(clazz, ClassLoaderFactory.forPluginDir()), clazz);
    }

    public static <T> Stream<T> loadAll(ServiceLoader<T> serviceLoader, @NotNull Class<T> clazz) {
        Objects.requireNonNull(clazz, "Service to load not specified.");
        return serviceLoader.stream().peek(serviceProvider -> IntegrationsLoader.logFoundServiceProvider(clazz, serviceProvider.type())).filter(IntegrationsLoader::isSupportedOperatingSystem).filter(IntegrationsLoader::passesStaticAvailabilityCheck).sorted(Comparator.comparingInt(IntegrationsLoader::getPriority).reversed()).flatMap(IntegrationsLoader::instantiateServiceProvider).filter(IntegrationsLoader::passesInstanceAvailabilityCheck).peek(impl -> IntegrationsLoader.logServiceIsAvailable(clazz, impl.getClass()));
    }

    private static void logFoundServiceProvider(Class<?> apiType, Class<?> implType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: Found implementation: {} in jar {}", new Object[]{apiType.getSimpleName(), implType.getName(), implType.getProtectionDomain().getCodeSource().getLocation().getPath()});
        }
    }

    private static int getPriority(ServiceLoader.Provider<?> provider) {
        Priority prio = provider.type().getAnnotation(Priority.class);
        return prio == null ? 0 : prio.value();
    }

    private static boolean isSupportedOperatingSystem(ServiceLoader.Provider<?> provider) {
        OperatingSystem[] annotations = (OperatingSystem[])provider.type().getAnnotationsByType(OperatingSystem.class);
        return annotations.length == 0 || Arrays.stream(annotations).anyMatch(OperatingSystem.Value::isCurrent);
    }

    private static <T> Stream<T> instantiateServiceProvider(ServiceLoader.Provider<T> provider) {
        try {
            return Stream.of(provider.get());
        }
        catch (ServiceConfigurationError err) {
            LOG.warn("Unable to load service provider {}.", (Object)provider.type().getName(), (Object)err);
            return Stream.empty();
        }
    }

    private static boolean passesStaticAvailabilityCheck(ServiceLoader.Provider<?> provider) {
        return IntegrationsLoader.passesStaticAvailabilityCheck(provider.type());
    }

    @VisibleForTesting
    static boolean passesStaticAvailabilityCheck(Class<?> type) {
        return IntegrationsLoader.silentlyPassesAvailabilityCheck(type, null);
    }

    @VisibleForTesting
    static boolean passesInstanceAvailabilityCheck(Object instance) {
        return IntegrationsLoader.silentlyPassesAvailabilityCheck(instance.getClass(), instance);
    }

    private static void logServiceIsAvailable(Class<?> apiType, Class<?> implType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: Implementation is available: {}", (Object)apiType.getSimpleName(), (Object)implType.getName());
        }
    }

    private static <T> boolean silentlyPassesAvailabilityCheck(Class<? extends T> type, @Nullable T instance) {
        try {
            return IntegrationsLoader.passesAvailabilityCheck(type, instance);
        }
        catch (ExceptionInInitializerError | NoClassDefFoundError | RuntimeException e) {
            LOG.warn("Unable to load service provider {}.", (Object)type.getName(), (Object)e);
            return false;
        }
    }

    private static <T> boolean passesAvailabilityCheck(Class<? extends T> type, @Nullable T instance) {
        if (!type.isAnnotationPresent(CheckAvailability.class)) {
            return true;
        }
        if (!type.getModule().isExported(type.getPackageName(), IntegrationsLoader.class.getModule())) {
            LOG.error("Can't run @CheckAvailability tests for class {}. Make sure to export {} to {}!", new Object[]{type.getName(), type.getPackageName(), IntegrationsLoader.class.getPackageName()});
            return false;
        }
        return Arrays.stream(type.getMethods()).filter(m -> IntegrationsLoader.isAvailabilityCheck(m, instance == null)).allMatch(m -> IntegrationsLoader.passesAvailabilityCheck(m, instance));
    }

    private static boolean passesAvailabilityCheck(Method m, @Nullable Object instance) {
        assert (Boolean.TYPE.equals(m.getReturnType()));
        try {
            return (Boolean)m.invoke(instance, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            LOG.warn("Failed to invoke @CheckAvailability test {}#{}", new Object[]{m.getDeclaringClass(), m.getName(), e});
            return false;
        }
    }

    private static boolean isAvailabilityCheck(Method m, boolean isStatic) {
        return m.isAnnotationPresent(CheckAvailability.class) && Boolean.TYPE.equals(m.getReturnType()) && m.getParameterCount() == 0 && Modifier.isStatic(m.getModifiers()) == isStatic;
    }
}

