/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.integrations.mount;

import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Stream;
import org.cryptomator.integrations.common.IntegrationsLoader;
import org.cryptomator.integrations.mount.MountBuilder;
import org.cryptomator.integrations.mount.MountCapability;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Range;

public interface MountService {
    public static Stream<MountService> get() {
        return IntegrationsLoader.loadAll(MountService.class).filter(MountService::isSupported);
    }

    public String displayName();

    public boolean isSupported();

    default public String getDefaultMountFlags() {
        throw new UnsupportedOperationException();
    }

    default public @Range(from=0L, to=32767L) int getDefaultLoopbackPort() {
        throw new UnsupportedOperationException();
    }

    public Set<MountCapability> capabilities();

    default public boolean hasCapability(MountCapability capability) {
        return this.capabilities().contains((Object)capability);
    }

    @Contract(value="_ -> new")
    public MountBuilder forFileSystem(Path var1);
}

