/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.linux.revealpath;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.cryptomator.integrations.revealpath.RevealFailedException;
import org.cryptomator.integrations.revealpath.RevealPathService;

public class DBusSendRevealPathService
implements RevealPathService {
    private static final String FILEMANAGER1_XML_ELEMENT = "<interface name=\"org.freedesktop.FileManager1\">";
    private static final String FOR_FOLDERS = "org.freedesktop.FileManager1.ShowFolders";
    private static final String FOR_FILES = "org.freedesktop.FileManager1.ShowItems";
    private static final int TIMEOUT_THRESHOLD = 5000;

    public void reveal(Path path) throws RevealFailedException {
        try {
            BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            String uriPath = Arrays.stream(path.toUri().getPath().split("/")).map(s -> URLEncoder.encode(s, StandardCharsets.UTF_8).replace("+", "%20")).collect(Collectors.joining("/"));
            ProcessBuilder pb = new ProcessBuilder(new String[0]).command("dbus-send", "--print-reply", "--reply-timeout=5000", "--dest=org.freedesktop.FileManager1", "--type=method_call", "/org/freedesktop/FileManager1", attrs.isDirectory() ? FOR_FOLDERS : FOR_FILES, String.format("array:string:file://%s", uriPath), "string:\"\"");
            Process process = pb.start();
            try (BufferedReader reader = process.errorReader();){
                if (process.waitFor(5000L, TimeUnit.MILLISECONDS)) {
                    int exitValue = process.exitValue();
                    if (process.exitValue() != 0) {
                        String error = reader.lines().collect(Collectors.joining());
                        throw new RevealFailedException("dbus-send exited with code " + exitValue + " and error message: " + error);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RevealFailedException((Exception)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RevealFailedException((Exception)e);
        }
    }

    public boolean isSupported() {
        try {
            Process fileManager1Exists = DBusSendRevealPathService.createFileManager1Check().start();
            if (fileManager1Exists.waitFor(5000L, TimeUnit.MILLISECONDS) && fileManager1Exists.exitValue() == 0) {
                return this.parseOutputForFileManagerInterface(fileManager1Exists);
            }
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        return false;
    }

    private boolean parseOutputForFileManagerInterface(Process fileManager1Process) throws IOException {
        if (fileManager1Process.isAlive()) {
            throw new IllegalArgumentException("Process " + String.valueOf(fileManager1Process) + " must be terminated to read output.");
        }
        try (BufferedReader reader = fileManager1Process.inputReader(StandardCharsets.UTF_8);){
            boolean bl = reader.lines().map(String::trim).anyMatch(FILEMANAGER1_XML_ELEMENT::equals);
            return bl;
        }
    }

    private static ProcessBuilder createFileManager1Check() {
        return new ProcessBuilder(new String[0]).command("dbus-send", "--session", "--print-reply", "--reply-timeout=5000", "--dest=org.freedesktop.FileManager1", "--type=method_call", "/org/freedesktop/FileManager1", "org.freedesktop.DBus.Introspectable.Introspect");
    }
}

