/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.jfuse.linux.aarch64;

import java.lang.foreign.MemorySegment;
import java.nio.file.StandardOpenOption;
import java.util.EnumSet;
import java.util.Set;
import org.cryptomator.jfuse.api.FileInfo;
import org.cryptomator.jfuse.linux.aarch64.extr.fcntl.fcntl_h;
import org.cryptomator.jfuse.linux.aarch64.extr.fuse3.fuse_file_info;
import org.jetbrains.annotations.Nullable;

record FileInfoImpl(MemorySegment segment) implements FileInfo
{
    private static final int O_RDONLY = fcntl_h.O_RDONLY();
    private static final int O_WRONLY = fcntl_h.O_WRONLY();
    private static final int O_RDWR = fcntl_h.O_RDWR();
    private static final int O_APPEND = fcntl_h.O_APPEND();
    private static final int O_CREAT = fcntl_h.O_CREAT();
    private static final int O_TRUNC = fcntl_h.O_TRUNC();
    private static final int O_EXCL = fcntl_h.O_EXCL();
    private static final int O_SYNC = fcntl_h.O_SYNC();
    private static final int O_DSYNC = fcntl_h.O_DSYNC();

    @Nullable
    public static FileInfoImpl ofNullable(MemorySegment address) {
        return MemorySegment.NULL.equals(address) ? null : new FileInfoImpl(address);
    }

    public long getFh() {
        return fuse_file_info.fh(this.segment);
    }

    public void setFh(long fh) {
        fuse_file_info.fh(this.segment, fh);
    }

    public int getFlags() {
        return fuse_file_info.flags(this.segment);
    }

    public Set<StandardOpenOption> getOpenFlags() {
        EnumSet<StandardOpenOption> result = EnumSet.noneOf(StandardOpenOption.class);
        int flags = this.getFlags();
        if ((flags & O_RDWR) == O_RDWR) {
            result.add(StandardOpenOption.READ);
            result.add(StandardOpenOption.WRITE);
        } else if ((flags & O_WRONLY) == O_WRONLY) {
            result.add(StandardOpenOption.WRITE);
        } else if ((flags & O_RDONLY) == O_RDONLY) {
            result.add(StandardOpenOption.READ);
        }
        if ((flags & O_CREAT) == O_CREAT && (flags & O_EXCL) == O_EXCL) {
            result.add(StandardOpenOption.CREATE_NEW);
        } else if ((flags & O_CREAT) == O_CREAT) {
            result.add(StandardOpenOption.CREATE);
        }
        if ((flags & O_APPEND) == O_APPEND) {
            result.add(StandardOpenOption.APPEND);
        }
        if ((flags & O_TRUNC) == O_TRUNC) {
            result.add(StandardOpenOption.TRUNCATE_EXISTING);
        }
        if ((flags & O_SYNC) == O_SYNC) {
            result.add(StandardOpenOption.SYNC);
        } else if ((flags & O_DSYNC) == O_DSYNC) {
            result.add(StandardOpenOption.DSYNC);
        }
        return result;
    }

    public long getLockOwner() {
        return fuse_file_info.lock_owner(this.segment);
    }
}

