/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.jfuse.linux.amd64;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.ByteBuffer;
import java.util.List;
import org.cryptomator.jfuse.api.DirFiller;
import org.cryptomator.jfuse.api.FileInfo;
import org.cryptomator.jfuse.api.Fuse;
import org.cryptomator.jfuse.api.FuseConfig;
import org.cryptomator.jfuse.api.FuseConnInfo;
import org.cryptomator.jfuse.api.FuseMount;
import org.cryptomator.jfuse.api.FuseMountFailedException;
import org.cryptomator.jfuse.api.FuseOperations;
import org.cryptomator.jfuse.api.Stat;
import org.cryptomator.jfuse.api.Statvfs;
import org.cryptomator.jfuse.api.TimeSpec;
import org.cryptomator.jfuse.api.util.MemoryUtils;
import org.cryptomator.jfuse.linux.amd64.DirFillerImpl;
import org.cryptomator.jfuse.linux.amd64.FileInfoImpl;
import org.cryptomator.jfuse.linux.amd64.FuseArgs;
import org.cryptomator.jfuse.linux.amd64.FuseConfigImpl;
import org.cryptomator.jfuse.linux.amd64.FuseConnInfoImpl;
import org.cryptomator.jfuse.linux.amd64.FuseFunctions;
import org.cryptomator.jfuse.linux.amd64.FuseMountImpl;
import org.cryptomator.jfuse.linux.amd64.FuseNewHelper;
import org.cryptomator.jfuse.linux.amd64.StatImpl;
import org.cryptomator.jfuse.linux.amd64.StatvfsImpl;
import org.cryptomator.jfuse.linux.amd64.TimeSpecImpl;
import org.cryptomator.jfuse.linux.amd64.extr.fuse3.fuse_args;
import org.cryptomator.jfuse.linux.amd64.extr.fuse3.fuse_h;
import org.cryptomator.jfuse.linux.amd64.extr.fuse3.fuse_operations;
import org.cryptomator.jfuse.linux.amd64.extr.fuse3.timespec;
import org.cryptomator.jfuse.linux.amd64.extr.fuse3_lowlevel.fuse_cmdline_opts;
import org.cryptomator.jfuse.linux.amd64.extr.stat.stat_h;
import org.jetbrains.annotations.VisibleForTesting;

final class FuseImpl
extends Fuse {
    public FuseImpl(FuseOperations fuseOperations) {
        super(fuseOperations, fuse_operations::allocate);
    }

    protected FuseMount mount(List<String> args) throws FuseMountFailedException {
        FuseArgs fuseArgs = this.parseArgs(args);
        MemorySegment fuse = this.createFuseFS(fuseArgs);
        if (fuse_h.fuse_mount(fuse, fuseArgs.mountPoint()) != 0) {
            throw new FuseMountFailedException("fuse_mount failed");
        }
        return new FuseMountImpl(fuse, fuseArgs);
    }

    @VisibleForTesting
    MemorySegment createFuseFS(FuseArgs fuseArgs) throws FuseMountFailedException {
        MemorySegment fuse = FuseNewHelper.getInstance().fuse_new(fuseArgs.args(), this.fuseOperationsStruct, this.fuseOperationsStruct.byteSize(), MemorySegment.NULL);
        if (MemorySegment.NULL.equals(fuse)) {
            throw new FuseMountFailedException("fuse_new failed");
        }
        return fuse;
    }

    @VisibleForTesting
    FuseArgs parseArgs(List<String> cmdLineArgs) throws IllegalArgumentException {
        MemorySegment args = fuse_args.allocate(this.fuseArena);
        int argc = cmdLineArgs.size();
        MemorySegment argv = this.fuseArena.allocate(ValueLayout.ADDRESS, (long)argc + 1L);
        for (int i = 0; i < argc; ++i) {
            MemorySegment cString = this.fuseArena.allocateFrom(cmdLineArgs.get(i));
            argv.setAtIndex(ValueLayout.ADDRESS, (long)i, cString);
        }
        argv.setAtIndex(ValueLayout.ADDRESS, (long)argc, MemorySegment.NULL);
        fuse_args.argc(args, argc);
        fuse_args.argv(args, argv);
        fuse_args.allocated(args, 0);
        MemorySegment opts = fuse_cmdline_opts.allocate(this.fuseArena);
        int parseResult = FuseFunctions.fuse_parse_cmdline(args, opts);
        if (parseResult != 0) {
            throw new IllegalArgumentException("fuse_parse_cmdline failed to parse " + String.join((CharSequence)" ", cmdLineArgs));
        }
        if (fuse_cmdline_opts.show_help(opts) == 1) {
            fuse_h.fuse_lib_help(args);
            throw new IllegalArgumentException("Flags contained -h or --help. Processing cancelled after printing help");
        }
        return new FuseArgs(args, opts);
    }

    protected void bind(FuseOperations.Operation operation) {
        switch (operation) {
            case INIT: {
                fuse_operations.init(this.fuseOperationsStruct, fuse_operations.init.allocate(this::init, this.fuseArena));
                break;
            }
            case ACCESS: {
                fuse_operations.access(this.fuseOperationsStruct, fuse_operations.access.allocate(this::access, this.fuseArena));
                break;
            }
            case CHMOD: {
                fuse_operations.chmod(this.fuseOperationsStruct, fuse_operations.chmod.allocate(this::chmod, this.fuseArena));
                break;
            }
            case CHOWN: {
                fuse_operations.chown(this.fuseOperationsStruct, fuse_operations.chown.allocate(this::chown, this.fuseArena));
                break;
            }
            case CREATE: {
                fuse_operations.create(this.fuseOperationsStruct, fuse_operations.create.allocate(this::create, this.fuseArena));
                break;
            }
            case DESTROY: {
                fuse_operations.destroy(this.fuseOperationsStruct, fuse_operations.destroy.allocate(this::destroy, this.fuseArena));
                break;
            }
            case FLUSH: {
                fuse_operations.flush(this.fuseOperationsStruct, fuse_operations.flush.allocate(this::flush, this.fuseArena));
                break;
            }
            case FSYNC: {
                fuse_operations.fsync(this.fuseOperationsStruct, fuse_operations.fsync.allocate(this::fsync, this.fuseArena));
                break;
            }
            case FSYNCDIR: {
                fuse_operations.fsyncdir(this.fuseOperationsStruct, fuse_operations.fsyncdir.allocate(this::fsyncdir, this.fuseArena));
                break;
            }
            case GET_ATTR: {
                fuse_operations.getattr(this.fuseOperationsStruct, fuse_operations.getattr.allocate(this::getattr, this.fuseArena));
                break;
            }
            case GET_XATTR: {
                fuse_operations.getxattr(this.fuseOperationsStruct, fuse_operations.getxattr.allocate(this::getxattr, this.fuseArena));
                break;
            }
            case LIST_XATTR: {
                fuse_operations.listxattr(this.fuseOperationsStruct, fuse_operations.listxattr.allocate(this::listxattr, this.fuseArena));
                break;
            }
            case MKDIR: {
                fuse_operations.mkdir(this.fuseOperationsStruct, fuse_operations.mkdir.allocate(this::mkdir, this.fuseArena));
                break;
            }
            case OPEN: {
                fuse_operations.open(this.fuseOperationsStruct, fuse_operations.open.allocate(this::open, this.fuseArena));
                break;
            }
            case OPEN_DIR: {
                fuse_operations.opendir(this.fuseOperationsStruct, fuse_operations.opendir.allocate(this::opendir, this.fuseArena));
                break;
            }
            case READ: {
                fuse_operations.read(this.fuseOperationsStruct, fuse_operations.read.allocate(this::read, this.fuseArena));
                break;
            }
            case READ_DIR: {
                fuse_operations.readdir(this.fuseOperationsStruct, fuse_operations.readdir.allocate(this::readdir, this.fuseArena));
                break;
            }
            case READLINK: {
                fuse_operations.readlink(this.fuseOperationsStruct, fuse_operations.readlink.allocate(this::readlink, this.fuseArena));
                break;
            }
            case RELEASE: {
                fuse_operations.release(this.fuseOperationsStruct, fuse_operations.release.allocate(this::release, this.fuseArena));
                break;
            }
            case RELEASE_DIR: {
                fuse_operations.releasedir(this.fuseOperationsStruct, fuse_operations.releasedir.allocate(this::releasedir, this.fuseArena));
                break;
            }
            case REMOVE_XATTR: {
                fuse_operations.removexattr(this.fuseOperationsStruct, fuse_operations.removexattr.allocate(this::removexattr, this.fuseArena));
                break;
            }
            case RENAME: {
                fuse_operations.rename(this.fuseOperationsStruct, fuse_operations.rename.allocate(this::rename, this.fuseArena));
                break;
            }
            case RMDIR: {
                fuse_operations.rmdir(this.fuseOperationsStruct, fuse_operations.rmdir.allocate(this::rmdir, this.fuseArena));
                break;
            }
            case SET_XATTR: {
                fuse_operations.setxattr(this.fuseOperationsStruct, fuse_operations.setxattr.allocate(this::setxattr, this.fuseArena));
                break;
            }
            case STATFS: {
                fuse_operations.statfs(this.fuseOperationsStruct, fuse_operations.statfs.allocate(this::statfs, this.fuseArena));
                break;
            }
            case SYMLINK: {
                fuse_operations.symlink(this.fuseOperationsStruct, fuse_operations.symlink.allocate(this::symlink, this.fuseArena));
                break;
            }
            case TRUNCATE: {
                fuse_operations.truncate(this.fuseOperationsStruct, fuse_operations.truncate.allocate(this::truncate, this.fuseArena));
                break;
            }
            case UNLINK: {
                fuse_operations.unlink(this.fuseOperationsStruct, fuse_operations.unlink.allocate(this::unlink, this.fuseArena));
                break;
            }
            case UTIMENS: {
                fuse_operations.utimens(this.fuseOperationsStruct, fuse_operations.utimens.allocate(this::utimens, this.fuseArena));
                break;
            }
            case WRITE: {
                fuse_operations.write(this.fuseOperationsStruct, fuse_operations.write.allocate(this::write, this.fuseArena));
            }
        }
    }

    @VisibleForTesting
    MemorySegment init(MemorySegment conn, MemorySegment cfg) {
        FuseConnInfoImpl connInfo = new FuseConnInfoImpl(conn);
        connInfo.setWant(connInfo.want() | 0x2000);
        FuseConfigImpl config = new FuseConfigImpl(cfg);
        this.fuseOperations.init((FuseConnInfo)connInfo, (FuseConfig)config);
        return MemorySegment.NULL;
    }

    private int access(MemorySegment path, int mask) {
        return this.fuseOperations.access(path.getString(0L), mask);
    }

    private int chmod(MemorySegment path, int mode, MemorySegment fi) {
        return this.fuseOperations.chmod(path.getString(0L), mode, (FileInfo)FileInfoImpl.ofNullable(fi));
    }

    @VisibleForTesting
    int chown(MemorySegment path, int uid, int gid, MemorySegment fi) {
        return this.fuseOperations.chown(path.getString(0L), uid, gid, (FileInfo)FileInfoImpl.ofNullable(fi));
    }

    private int create(MemorySegment path, int mode, MemorySegment fi) {
        return this.fuseOperations.create(path.getString(0L), mode, (FileInfo)new FileInfoImpl(fi));
    }

    private void destroy(MemorySegment addr) {
        this.fuseOperations.destroy();
    }

    @VisibleForTesting
    int flush(MemorySegment path, MemorySegment fi) {
        return this.fuseOperations.flush(path.getString(0L), (FileInfo)new FileInfoImpl(fi));
    }

    @VisibleForTesting
    int fsync(MemorySegment path, int datasync, MemorySegment fi) {
        return this.fuseOperations.fsync(path.getString(0L), datasync, (FileInfo)new FileInfoImpl(fi));
    }

    @VisibleForTesting
    int fsyncdir(MemorySegment path, int datasync, MemorySegment fi) {
        return this.fuseOperations.fsyncdir(MemoryUtils.toUtf8StringOrNull((MemorySegment)path), datasync, (FileInfo)new FileInfoImpl(fi));
    }

    private int getattr(MemorySegment path, MemorySegment stat2, MemorySegment fi) {
        return this.fuseOperations.getattr(path.getString(0L), (Stat)new StatImpl(stat2), (FileInfo)FileInfoImpl.ofNullable(fi));
    }

    @VisibleForTesting
    int getxattr(MemorySegment path, MemorySegment name, MemorySegment value, long size) {
        ByteBuffer val = value.reinterpret(size).asByteBuffer();
        return this.fuseOperations.getxattr(path.getString(0L), name.getString(0L), val);
    }

    @VisibleForTesting
    int setxattr(MemorySegment path, MemorySegment name, MemorySegment value, long size, int flags) {
        ByteBuffer val = value.reinterpret(size).asByteBuffer();
        return this.fuseOperations.setxattr(path.getString(0L), name.getString(0L), val, flags);
    }

    @VisibleForTesting
    int listxattr(MemorySegment path, MemorySegment value, long size) {
        ByteBuffer val = value.reinterpret(size).asByteBuffer();
        return this.fuseOperations.listxattr(path.getString(0L), val);
    }

    @VisibleForTesting
    int removexattr(MemorySegment path, MemorySegment name) {
        return this.fuseOperations.removexattr(path.getString(0L), name.getString(0L));
    }

    private int mkdir(MemorySegment path, int mode) {
        return this.fuseOperations.mkdir(path.getString(0L), mode);
    }

    private int open(MemorySegment path, MemorySegment fi) {
        return this.fuseOperations.open(path.getString(0L), (FileInfo)new FileInfoImpl(fi));
    }

    private int opendir(MemorySegment path, MemorySegment fi) {
        return this.fuseOperations.opendir(path.getString(0L), (FileInfo)new FileInfoImpl(fi));
    }

    private int read(MemorySegment path, MemorySegment buf, long size, long offset, MemorySegment fi) {
        ByteBuffer buffer = buf.reinterpret(size).asByteBuffer();
        return this.fuseOperations.read(path.getString(0L), buffer, size, offset, (FileInfo)new FileInfoImpl(fi));
    }

    private int readdir(MemorySegment path, MemorySegment buf, MemorySegment filler, long offset, MemorySegment fi, int flags) {
        try (Arena arena = Arena.ofConfined();){
            int n = this.fuseOperations.readdir(path.getString(0L), (DirFiller)new DirFillerImpl(buf, filler, arena), offset, (FileInfo)new FileInfoImpl(fi), flags);
            return n;
        }
    }

    private int readlink(MemorySegment path, MemorySegment buf, long len) {
        ByteBuffer buffer = buf.reinterpret(len).asByteBuffer();
        return this.fuseOperations.readlink(path.getString(0L), buffer, len);
    }

    private int release(MemorySegment path, MemorySegment fi) {
        return this.fuseOperations.release(path.getString(0L), (FileInfo)new FileInfoImpl(fi));
    }

    private int releasedir(MemorySegment path, MemorySegment fi) {
        return this.fuseOperations.releasedir(MemoryUtils.toUtf8StringOrNull((MemorySegment)path), (FileInfo)new FileInfoImpl(fi));
    }

    private int rename(MemorySegment oldpath, MemorySegment newpath, int flags) {
        return this.fuseOperations.rename(oldpath.getString(0L), newpath.getString(0L), flags);
    }

    private int rmdir(MemorySegment path) {
        return this.fuseOperations.rmdir(path.getString(0L));
    }

    private int statfs(MemorySegment path, MemorySegment statvfs2) {
        return this.fuseOperations.statfs(path.getString(0L), (Statvfs)new StatvfsImpl(statvfs2));
    }

    private int symlink(MemorySegment linkname, MemorySegment target) {
        return this.fuseOperations.symlink(linkname.getString(0L), target.getString(0L));
    }

    private int truncate(MemorySegment path, long size, MemorySegment fi) {
        return this.fuseOperations.truncate(path.getString(0L), size, (FileInfo)FileInfoImpl.ofNullable(fi));
    }

    private int unlink(MemorySegment path) {
        return this.fuseOperations.unlink(path.getString(0L));
    }

    @VisibleForTesting
    int utimens(MemorySegment path, MemorySegment times, MemorySegment fi) {
        try (Arena arena = Arena.ofConfined();){
            if (MemorySegment.NULL.equals(times)) {
                MemorySegment segment = timespec.allocate(arena);
                timespec.tv_sec(segment, 0L);
                timespec.tv_nsec(segment, stat_h.UTIME_NOW());
                TimeSpecImpl time = new TimeSpecImpl(segment);
                int n = this.fuseOperations.utimens(path.getString(0L), (TimeSpec)time, (TimeSpec)time, (FileInfo)FileInfoImpl.ofNullable(fi));
                return n;
            }
            MemorySegment time0 = timespec.asSlice(times, 0L);
            MemorySegment time1 = timespec.asSlice(times, 1L);
            int n = this.fuseOperations.utimens(path.getString(0L), (TimeSpec)new TimeSpecImpl(time0), (TimeSpec)new TimeSpecImpl(time1), (FileInfo)FileInfoImpl.ofNullable(fi));
            return n;
        }
    }

    private int write(MemorySegment path, MemorySegment buf, long size, long offset, MemorySegment fi) {
        ByteBuffer buffer = buf.reinterpret(size).asByteBuffer();
        return this.fuseOperations.write(path.getString(0L), buffer, size, offset, (FileInfo)new FileInfoImpl(fi));
    }
}

