/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.webdav.mount;

import java.net.URI;
import java.nio.file.Path;
import java.util.Set;
import org.cryptomator.frontend.webdav.WebDavServerHandle;
import org.cryptomator.frontend.webdav.mount.AbstractMount;
import org.cryptomator.frontend.webdav.mount.AbstractMountBuilder;
import org.cryptomator.frontend.webdav.servlet.WebDavServletController;
import org.cryptomator.integrations.common.Priority;
import org.cryptomator.integrations.mount.Mount;
import org.cryptomator.integrations.mount.MountBuilder;
import org.cryptomator.integrations.mount.MountCapability;
import org.cryptomator.integrations.mount.MountService;
import org.cryptomator.integrations.mount.Mountpoint;

@Priority(value=-2147483648)
public class FallbackMounter
implements MountService {
    public String displayName() {
        return "WebDAV (HTTP Address)";
    }

    public boolean isSupported() {
        return true;
    }

    public Set<MountCapability> capabilities() {
        return Set.of(MountCapability.LOOPBACK_PORT, MountCapability.VOLUME_ID);
    }

    public int getDefaultLoopbackPort() {
        return 0;
    }

    public MountBuilder forFileSystem(Path path) {
        return new MountBuilderImpl(path);
    }

    private static class MountBuilderImpl
    extends AbstractMountBuilder {
        public MountBuilderImpl(Path vfsRoot) {
            super(vfsRoot);
        }

        @Override
        protected Mount mount(WebDavServerHandle serverHandle, WebDavServletController servlet, URI uri) {
            return new MountImpl(serverHandle, servlet, uri);
        }
    }

    private static class MountImpl
    extends AbstractMount {
        private final URI uri;

        public MountImpl(WebDavServerHandle serverHandle, WebDavServletController servlet, URI uri) {
            super(serverHandle, servlet);
            this.uri = uri;
        }

        public Mountpoint getMountpoint() {
            return Mountpoint.forUri((URI)this.uri);
        }
    }
}

