/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import java.util.function.BiPredicate;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.Hash;
import org.cyclonedx.util.BomUtils;

public class ExternalReferenceSerializer
extends StdSerializer<ExternalReference> {
    public ExternalReferenceSerializer() {
        this(null);
    }

    public ExternalReferenceSerializer(Class<ExternalReference> t) {
        super(t);
    }

    public void serialize(ExternalReference extRef, JsonGenerator gen, SerializerProvider provider) throws IOException {
        BiPredicate<ExternalReference.Type, String> validateExternalReference = (type, url) -> type != null && url != null && BomUtils.validateUrlString(url);
        if (gen instanceof ToXmlGenerator) {
            ToXmlGenerator toXmlGenerator = (ToXmlGenerator)gen;
            XMLStreamWriter staxWriter = toXmlGenerator.getStaxWriter();
            if (validateExternalReference.test(extRef.getType(), extRef.getUrl())) {
                try {
                    staxWriter.writeStartElement("reference");
                    staxWriter.writeAttribute("type", extRef.getType().getTypeName());
                    staxWriter.writeStartElement("url");
                    staxWriter.writeCharacters(extRef.getUrl());
                    staxWriter.writeEndElement();
                    if (extRef.getComment() != null) {
                        staxWriter.writeStartElement("comment");
                        staxWriter.writeCharacters(extRef.getComment());
                        staxWriter.writeEndElement();
                    }
                    if (extRef.getHashes() != null && !extRef.getHashes().isEmpty()) {
                        staxWriter.writeStartElement("hashes");
                        for (Hash hash : extRef.getHashes()) {
                            if (hash == null) continue;
                            staxWriter.writeStartElement("hash");
                            staxWriter.writeAttribute("alg", hash.getAlgorithm());
                            staxWriter.writeCharacters(hash.getValue());
                            staxWriter.writeEndElement();
                        }
                        staxWriter.writeEndElement();
                    }
                    staxWriter.writeEndElement();
                }
                catch (XMLStreamException ex) {
                    throw new IOException(ex);
                }
            }
        } else if (validateExternalReference.test(extRef.getType(), extRef.getUrl())) {
            gen.writeStartObject();
            gen.writeStringField("type", extRef.getType().getTypeName());
            gen.writeStringField("url", extRef.getUrl());
            if (extRef.getComment() != null) {
                gen.writeStringField("comment", extRef.getComment());
            }
            if (extRef.getHashes() != null && !extRef.getHashes().isEmpty()) {
                gen.writePOJOField("hashes", extRef.getHashes());
            }
            gen.writeEndObject();
        }
    }
}

