/*
 * This file is part of CycloneDX Core (Java).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 * Copyright (c) OWASP Foundation. All Rights Reserved.
 */
package org.cyclonedx.model.vulnerability;

import org.cyclonedx.model.vulnerability.Vulnerability10.Score;
import org.cyclonedx.model.vulnerability.Vulnerability10.ScoreSource;
import org.cyclonedx.model.vulnerability.Vulnerability10.Severity;

public class Rating
{
  private Score score;

  private Severity severity;

  private ScoreSource method;

  private String vector;

  public Score getScore() {
    return score;
  }

  public void setScore(final Score score) {
    this.score = score;
  }

  public Severity getSeverity() {
    return severity;
  }

  public void setSeverity(final Severity severity) {
    this.severity = severity;
  }

  public ScoreSource getMethod() {
    return method;
  }

  public void setMethod(final ScoreSource method) {
    this.method = method;
  }

  public String getVector() {
    return vector;
  }

  public void setVector(final String vector) {
    this.vector = vector;
  }
}
