/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cyclonedx.model.OrganizationalContact;
import org.cyclonedx.model.VersionFilter;
import org.cyclonedx.util.deserializer.OrganizationalEntityDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"name", "url", "contact"})
@JsonDeserialize(using=OrganizationalEntityDeserializer.class)
public class OrganizationalEntity {
    @JacksonXmlProperty(isAttribute=true, localName="bom-ref")
    @JsonProperty(value="bom-ref")
    @VersionFilter(versions={"1.0", "1.1", "1.2", "1.3", "1.4"})
    private String bomRef;
    private String name;
    private List<String> url;
    @JsonProperty(value="contact")
    private List<OrganizationalContact> contact;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="url")
    @JsonProperty(value="url")
    public List<String> getUrls() {
        return this.url;
    }

    public void setUrls(List<String> url) {
        this.url = url;
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="contact")
    @JsonProperty(value="contact")
    public List<OrganizationalContact> getContacts() {
        return this.contact;
    }

    public void setContacts(List<OrganizationalContact> contacts) {
        this.contact = contacts;
    }

    public void addContact(OrganizationalContact contact) {
        if (this.contact == null) {
            this.contact = new ArrayList<OrganizationalContact>();
        }
        this.contact.add(contact);
    }

    public String getBomRef() {
        return this.bomRef;
    }

    public void setBomRef(String bomRef) {
        this.bomRef = bomRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationalEntity that = (OrganizationalEntity)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.url, that.url) && Objects.equals(this.contact, that.contact) && Objects.equals(this.bomRef, that.bomRef);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.url, this.contact, this.bomRef);
    }
}

