/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.cyclonedx.model.AttachmentText;

public class AttachmentTextDeserializer
extends StdDeserializer<AttachmentText> {
    public AttachmentTextDeserializer() {
        this(null);
    }

    public AttachmentTextDeserializer(Class<?> vc) {
        super(vc);
    }

    public AttachmentText deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode encodingNode;
        ObjectCodec codec = parser.getCodec();
        JsonNode node = (JsonNode)codec.readTree(parser);
        AttachmentText attachmentText = new AttachmentText();
        JsonNode textNode = node.get("content");
        if (textNode != null) {
            attachmentText.setText(textNode.textValue());
        } else if (node.has("")) {
            attachmentText.setText(node.get("").asText());
        }
        JsonNode contentTypeNode = node.get("content-type");
        if (contentTypeNode == null || !contentTypeNode.isTextual()) {
            contentTypeNode = node.get("contentType");
        }
        if (contentTypeNode != null && contentTypeNode.isTextual()) {
            attachmentText.setContentType(contentTypeNode.textValue());
        }
        if ((encodingNode = node.get("encoding")) != null && encodingNode.isTextual()) {
            attachmentText.setEncoding(encodingNode.textValue());
        }
        return attachmentText;
    }
}

