/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.formulation.common.EnvVariableChoice;

public class EnvVariableChoiceDeserializer
extends JsonDeserializer<EnvVariableChoice> {
    public EnvVariableChoice deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        EnvVariableChoice envReferenceChoice = new EnvVariableChoice();
        if (node.has("value")) {
            String value = node.get("value").asText();
            envReferenceChoice.setValue(value);
        } else if (node.has("environmentVar")) {
            JsonNode envVarNode = node.get("environmentVar");
            Property prop = new Property();
            if (envVarNode.has("name")) {
                String name = envVarNode.get("name").asText();
                prop.setName(name);
            }
            if (envVarNode.has("")) {
                String value = envVarNode.get("").asText();
                prop.setValue(value);
            }
            envReferenceChoice.setEnvironmentVar(prop);
        }
        return envReferenceChoice;
    }
}

