/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.cyclonedx.model.AttachmentText;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.formulation.common.EnvVariableChoice;
import org.cyclonedx.model.formulation.common.InputType;
import org.cyclonedx.model.formulation.common.ResourceReferenceChoice;

public class InputTypeDeserializer
extends JsonDeserializer<InputType> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public InputType deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        InputType inputType = new InputType();
        if (node.has("source")) {
            JsonNode sourceNode = node.get("source");
            ResourceReferenceChoice source = (ResourceReferenceChoice)this.objectMapper.treeToValue((TreeNode)sourceNode, ResourceReferenceChoice.class);
            inputType.setSource(source);
        }
        if (node.has("target")) {
            JsonNode targetNode = node.get("target");
            ResourceReferenceChoice target = (ResourceReferenceChoice)this.objectMapper.treeToValue((TreeNode)targetNode, ResourceReferenceChoice.class);
            inputType.setTarget(target);
        }
        this.createInputDataInfo(node, inputType);
        if (node.has("properties")) {
            JsonNode propertiesNode = node.get("properties");
            List properties = (List)this.objectMapper.convertValue((Object)propertiesNode, (TypeReference)new TypeReference<List<Property>>(){});
            inputType.setProperties(properties);
        }
        return inputType;
    }

    private void createInputDataInfo(JsonNode node, InputType inputType) throws JsonProcessingException {
        if (node.has("resource")) {
            JsonNode resourceNode = node.get("resource");
            ResourceReferenceChoice resource = (ResourceReferenceChoice)this.objectMapper.treeToValue((TreeNode)resourceNode, ResourceReferenceChoice.class);
            inputType.setResource(resource);
        } else if (node.has("parameters")) {
            JsonNode parametersNode = node.get("parameters");
            List parameters = (List)this.objectMapper.convertValue((Object)parametersNode, (TypeReference)new TypeReference<List<InputType.Parameter>>(){});
            inputType.setParameters(parameters);
        } else if (node.has("environmentVars")) {
            JsonNode nodes = node.get("environmentVars");
            ArrayList<EnvVariableChoice> environmentVars = new ArrayList<EnvVariableChoice>();
            ArrayNode environmentVarsNode = nodes.isArray() ? (ArrayNode)nodes : new ArrayNode(null).add(nodes);
            for (JsonNode envVarNode : environmentVarsNode) {
                EnvVariableChoice envVar = (EnvVariableChoice)this.objectMapper.treeToValue((TreeNode)envVarNode, EnvVariableChoice.class);
                environmentVars.add(envVar);
            }
            inputType.setEnvironmentVars(environmentVars);
        } else if (node.has("data")) {
            JsonNode dataNode = node.get("data");
            AttachmentText data = (AttachmentText)this.objectMapper.treeToValue((TreeNode)dataNode, AttachmentText.class);
            inputType.setData(data);
        }
    }
}

