/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.cyclonedx.model.AttachmentText;
import org.cyclonedx.model.ReleaseNotes;

public class NotesDeserializer
extends JsonDeserializer<List<ReleaseNotes.Notes>> {
    private final ObjectMapper mapper = new ObjectMapper();

    public List<ReleaseNotes.Notes> deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        if (node.has("note")) {
            return this.parseNode(node.get("note"));
        }
        return this.parseNode(node);
    }

    private List<ReleaseNotes.Notes> parseNode(JsonNode node) throws JsonProcessingException {
        ArrayList<ReleaseNotes.Notes> list = new ArrayList<ReleaseNotes.Notes>();
        ArrayNode nodes = node.isArray() ? (ArrayNode)node : new ArrayNode(null).add(node);
        for (JsonNode noteNode : nodes) {
            ReleaseNotes.Notes notes = this.parseNotes(noteNode);
            list.add(notes);
        }
        return list;
    }

    private ReleaseNotes.Notes parseNotes(JsonNode node) throws JsonProcessingException {
        ReleaseNotes.Notes notes = new ReleaseNotes.Notes();
        if (node.has("locale")) {
            notes.setLocale(node.get("locale").asText());
        }
        if (node.has("text")) {
            JsonNode dataNode = node.get("text");
            AttachmentText data = (AttachmentText)this.mapper.treeToValue((TreeNode)dataNode, AttachmentText.class);
            notes.setText(data);
        }
        return notes;
    }
}

