/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.cyclonedx.model.OrganizationalChoice;
import org.cyclonedx.model.OrganizationalContact;
import org.cyclonedx.model.OrganizationalEntity;

public class OrganizationalChoiceDeserializer
extends JsonDeserializer<OrganizationalChoice> {
    public OrganizationalChoice deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        OrganizationalChoice organizationalChoice = new OrganizationalChoice();
        if (node.has("individual")) {
            OrganizationalContact individual = (OrganizationalContact)jp.getCodec().treeToValue((TreeNode)node.get("individual"), OrganizationalContact.class);
            organizationalChoice.setIndividual(individual);
        } else if (node.has("organization")) {
            JsonNode organizationNode = node.get("organization");
            OrganizationalEntity organization = new OrganizationalEntity();
            organization.setName(organizationNode.get("name").asText());
            if (organizationNode.has("contact")) {
                JsonNode contactsNode = organizationNode.get("contact");
                if (contactsNode instanceof ArrayNode) {
                    for (JsonNode contactNode : contactsNode) {
                        OrganizationalContact contact = (OrganizationalContact)jp.getCodec().treeToValue((TreeNode)contactNode, OrganizationalContact.class);
                        organization.addContact(contact);
                    }
                } else if (contactsNode instanceof ObjectNode) {
                    OrganizationalContact contact = (OrganizationalContact)jp.getCodec().treeToValue((TreeNode)contactsNode, OrganizationalContact.class);
                    organization.addContact(contact);
                }
            }
            organizationalChoice.setOrganization(organization);
        }
        return organizationalChoice;
    }
}

