/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import org.cyclonedx.model.formulation.common.EnvVariableChoice;
import org.cyclonedx.model.formulation.common.InputType;

public class InputTypeSerializer
extends StdSerializer<InputType> {
    private final boolean isXml;

    public InputTypeSerializer(boolean isXml) {
        this(null, isXml);
    }

    public InputTypeSerializer(Class<InputType> t, boolean isXml) {
        super(t);
        this.isXml = isXml;
    }

    public void serialize(InputType value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.isXml && jsonGenerator instanceof ToXmlGenerator) {
            ToXmlGenerator xmlGenerator = (ToXmlGenerator)jsonGenerator;
            this.createInputChoice(value, (JsonGenerator)xmlGenerator);
        } else {
            this.createInputChoice(value, jsonGenerator);
        }
    }

    private void createInputChoice(InputType input, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartObject();
        if (input.getResource() != null) {
            jsonGenerator.writeFieldName("resource");
            jsonGenerator.writeObject((Object)input.getResource());
        } else if (input.getParameters() != null && !input.getParameters().isEmpty()) {
            jsonGenerator.writeFieldName("parameters");
            jsonGenerator.writeObject(input.getParameters());
        } else if (input.getEnvironmentVars() != null && !input.getEnvironmentVars().isEmpty()) {
            jsonGenerator.writeArrayFieldStart("environmentVars");
            for (EnvVariableChoice envVarChoice : input.getEnvironmentVars()) {
                if (envVarChoice.getEnvironmentVar() != null) {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeObjectField("environmentVar", (Object)envVarChoice.getEnvironmentVar());
                    jsonGenerator.writeEndObject();
                    continue;
                }
                if (envVarChoice.getValue() == null) continue;
                jsonGenerator.writeStartObject();
                jsonGenerator.writeObjectField("value", (Object)envVarChoice.getValue());
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
        } else if (input.getData() != null) {
            jsonGenerator.writeFieldName("data");
            jsonGenerator.writeObject((Object)input.getData());
        }
        if (input.getSource() != null) {
            jsonGenerator.writeFieldName("source");
            jsonGenerator.writeObject((Object)input.getSource());
        }
        if (input.getTarget() != null) {
            jsonGenerator.writeFieldName("target");
            jsonGenerator.writeObject((Object)input.getTarget());
        }
        if (input.getProperties() != null) {
            jsonGenerator.writeFieldName("properties");
            jsonGenerator.writeObject(input.getProperties());
        }
        jsonGenerator.writeEndObject();
    }

    public Class<InputType> handledType() {
        return InputType.class;
    }
}

