/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.maven;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.cyclonedx.maven.BaseCycloneDxMojo;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;

@Mojo(name="makePackageBom", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, aggregator=true, requiresOnline=true, requiresDependencyCollection=ResolutionScope.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class CycloneDxPackageMojo
extends BaseCycloneDxMojo {
    protected boolean shouldInclude(MavenProject mavenProject) {
        return Arrays.asList("war", "ear").contains(mavenProject.getPackaging());
    }

    public void execute() throws MojoExecutionException {
        boolean shouldSkip = Boolean.parseBoolean(System.getProperty("cyclonedx.skip", Boolean.toString(this.getSkip())));
        if (shouldSkip) {
            this.getLog().info((CharSequence)"Skipping CycloneDX");
            return;
        }
        this.logParameters();
        LinkedHashSet<Component> components = new LinkedHashSet<Component>();
        LinkedHashSet<String> componentRefs = new LinkedHashSet<String>();
        LinkedHashSet<Dependency> dependencies = new LinkedHashSet<Dependency>();
        for (MavenProject mavenProject : this.getReactorProjects()) {
            if (!this.shouldInclude(mavenProject)) continue;
            this.getLog().info((CharSequence)("Analyzing " + mavenProject.getArtifactId()));
            for (Artifact artifact : mavenProject.getArtifacts()) {
                if (!this.shouldInclude(artifact)) continue;
                Component component = this.convert(artifact);
                boolean found = false;
                for (String s : componentRefs) {
                    if (s == null || !s.equals(component.getBomRef())) continue;
                    found = true;
                }
                if (found) continue;
                componentRefs.add(component.getBomRef());
                components.add(component);
            }
            if (!(this.schemaVersion().getVersion() >= 1.2)) continue;
            dependencies.addAll(this.buildDependencyGraph(componentRefs, mavenProject));
        }
        super.execute(components, dependencies, this.getProject());
    }
}

