/*
 * Decompiled with CFR 0.152.
 */
package org.dacapo.harness;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import org.dacapo.harness.Benchmark;
import org.dacapo.parser.Config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DacapoClassLoader
extends URLClassLoader {
    public static DacapoClassLoader create(Config config, File scratch) {
        DacapoClassLoader rtn = null;
        try {
            URL[] urls = DacapoClassLoader.getJars(config, scratch);
            if (Benchmark.getVerbose()) {
                System.out.println("Benchmark classpath:");
                for (URL url : urls) {
                    System.out.println("  " + url.toString());
                }
            }
            rtn = new DacapoClassLoader(urls, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            System.err.println("Unable to create loader for " + config.name + ":");
            e.printStackTrace();
            System.exit(-1);
        }
        return rtn;
    }

    public DacapoClassLoader(URL[] urls) {
        super(urls);
    }

    public DacapoClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public DacapoClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
    }

    private static URL[] getJars(Config config, File scratch) throws MalformedURLException {
        ArrayList<URL> jars = new ArrayList<URL>();
        File jardir = new File(scratch, "jar");
        if (config.jar != null) {
            File jar = new File(jardir, config.jar);
            jars.add(jar.toURL());
        }
        if (config.libs != null) {
            for (int i = 0; i < config.libs.length; ++i) {
                File jar = new File(jardir, config.libs[i]);
                jars.add(jar.toURL());
            }
        }
        return jars.toArray(new URL[jars.size()]);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = super.findClass(name);
            }
            catch (ClassNotFoundException e) {
                c = super.loadClass(name, resolve);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }
}

