/*
 * Decompiled with CFR 0.152.
 */
package org.dacapo.harness;

import java.io.File;
import java.lang.reflect.Method;
import org.dacapo.harness.Benchmark;
import org.dacapo.parser.Config;

public class Eclipse
extends Benchmark {
    static final String WKSP_DIRECTORY_RELATIVE_TO_SCRATCH = "workspace";
    static final String PLUGIN_ID = "org.dacapo.eclipse.Harness";
    static final String OSGI_BOOTSTRAP_JAR = "eclipse" + File.separator + "plugins" + File.separator + "org.eclipse.osgi_3.5.1.R35x_v20090827.jar";
    static String oldJavaHome = null;
    static Eclipse eclipse;
    static String size;
    private final Method isRunning;
    private final Method run;
    private final Method shutdown;

    public Eclipse(Config config, File scratch) throws Exception {
        super(config, scratch, false);
        Class<?> clazz = Class.forName("org.eclipse.core.runtime.adaptor.EclipseStarter", true, this.loader);
        this.method = clazz.getMethod("startup", String[].class, Runnable.class);
        this.isRunning = clazz.getMethod("isRunning", new Class[0]);
        this.run = clazz.getMethod("run", Object.class);
        this.shutdown = clazz.getMethod("shutdown", new Class[0]);
    }

    public void preIteration(String size) throws Exception {
        super.preIteration(size);
        if (!((Boolean)this.isRunning.invoke(null, (Object[])null)).booleanValue()) {
            this.startup(size);
        }
        this.setJavaHomeIfRequired();
        try {
            String[] largePluginArgs = new String[]{"large", "unzip"};
            String[] pluginArgs = new String[]{"unzip"};
            this.run.invoke(null, new Object[]{size.equals("large") ? largePluginArgs : pluginArgs});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void iterate(String size) throws Exception {
        try {
            String[] pluginArgs = this.config.getArgs(size);
            this.run.invoke(null, new Object[]{pluginArgs});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void postIteration(String size) throws Exception {
        try {
            String[] pluginArgs = new String[]{"teardown"};
            this.run.invoke(null, new Object[]{pluginArgs});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.postIteration(size);
        this.restoreJavaHomeIfRequired();
    }

    public void cleanup() {
        try {
            this.shutdown.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startup(String size) {
        try {
            System.setProperty("osgi.os", "linux");
            System.setProperty("osgi.ws", "gtk");
            System.setProperty("osgi.arch", "x86");
            System.setProperty("osgi.install.area", "file:" + this.fileInScratch("eclipse/"));
            System.setProperty("osgi.noShutdown", "true");
            System.setProperty("osgi.framework", "file:" + this.fileInScratch(OSGI_BOOTSTRAP_JAR));
            this.setJavaHomeIfRequired();
            String[] args = new String[]{"-data", this.fileInScratch(WKSP_DIRECTORY_RELATIVE_TO_SCRATCH), "-application", PLUGIN_ID};
            this.method.invoke(null, new Object[]{args, null});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setJavaHomeIfRequired() {
        String eclipseJavaHome = System.getProperty("eclipse.java.home");
        if (eclipseJavaHome != null) {
            oldJavaHome = System.getProperty("java.home");
            System.setProperty("java.home", eclipseJavaHome);
        }
    }

    private void restoreJavaHomeIfRequired() {
        if (oldJavaHome != null) {
            System.setProperty("java.home", oldJavaHome);
        }
    }
}

