/*
 * Decompiled with CFR 0.152.
 */
package org.dacapo.harness;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dacapo.harness.Benchmark;
import org.dacapo.parser.Config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pmd
extends Benchmark {
    String[] args;

    public Pmd(Config config, File scratch) throws Exception {
        super(config, scratch);
        Class<?> clazz = Class.forName("net.sourceforge.pmd.PMD", true, this.loader);
        this.method = clazz.getMethod("main", String[].class);
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
    }

    @Override
    public void prepare(String size) {
        this.args = this.config.getArgs(size);
        if (this.args[0].charAt(0) == '@') {
            this.args[0] = this.collectFilesFromFile(this.fileInScratch(this.args[0].substring(1)));
        }
        for (int i = 2; i < this.args.length; ++i) {
            if (this.args[i].charAt(0) == '-') continue;
            this.args[i] = this.fileInScratch(this.args[i]);
        }
    }

    @Override
    public void iterate(String size) throws Exception {
        this.method.invoke(null, new Object[]{this.args});
    }

    private String collectFilesFromFile(String inputFileName) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(inputFileName)));
            ArrayList<File> files = new ArrayList<File>();
            String l = reader.readLine();
            while (l != null) {
                files.add(new File(this.scratch, l));
                l = reader.readLine();
            }
            return Pmd.commaSeparate(files);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File " + inputFileName + " error: " + e);
        }
        catch (IOException e) {
            throw new RuntimeException("File " + inputFileName + " error: " + e);
        }
    }

    private static String commaSeparate(List<File> list) {
        String result = "";
        Iterator<File> i = list.iterator();
        while (i.hasNext()) {
            String s = i.next().getPath();
            result = result + s;
            if (!i.hasNext()) continue;
            result = result + ",";
        }
        return result;
    }
}

