/*
 * Decompiled with CFR 0.152.
 */
package org.dacapo.harness;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.dacapo.harness.Benchmark;

public class Slice {
    private static void extract(File inFile, File outFile, int offset, int length) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(inFile));
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(outFile)));
        for (int lineNo = 0; (line = in.readLine()) != null && lineNo < offset + length; ++lineNo) {
            if (offset > lineNo || lineNo >= offset + length) continue;
            out.println(line);
        }
        in.close();
        out.close();
    }

    public static void slice(File file, File dir, int fraction) throws IOException {
        int length = Benchmark.lineCount(file);
        int lines = length / fraction;
        for (int pass = 1; pass <= fraction; ++pass) {
            int chunk = pass * lines;
            int offset = 0;
            int n = 0;
            while (offset <= length - chunk) {
                File outFile = new File(dir, file.getName() + "." + fraction + "." + pass + "." + n);
                Slice.extract(file, outFile, offset, chunk);
                offset += lines;
                ++n;
            }
        }
    }

    public static void main(String[] args) throws IOException {
        String file = args[0];
        String targetDir = args[1];
        int fraction = Integer.parseInt(args[2]);
        Slice.slice(new File(file), new File(targetDir), fraction);
    }
}

