/*
 * Decompiled with CFR 0.152.
 */
package org.dacapo.harness;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TeeOutputStream
extends FilterOutputStream {
    private OutputStream log = null;
    private int version = 0;
    private final File logFile;
    private boolean toScreen = false;

    public TeeOutputStream(OutputStream stream, File logFile) {
        super(stream);
        this.logFile = logFile;
        this.newLog();
    }

    public void enableOutput(boolean enable) {
        this.toScreen = enable;
    }

    private void newLog() {
        try {
            this.log = new FileOutputStream(this.logFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void openLog() {
        this.newLog();
    }

    public void closeLog() {
        try {
            this.flush();
            this.log.close();
            this.log = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() throws IOException {
        super.close();
        if (this.log != null) {
            this.log.close();
        }
    }

    public void flush() throws IOException {
        super.flush();
        if (this.log != null) {
            this.log.flush();
        }
    }

    public void write(int b) throws IOException {
        if (this.toScreen) {
            super.write(b);
            super.flush();
        }
        if (this.log != null) {
            this.log.write(b);
            this.log.flush();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.flush();
            this.close();
            super.finalize();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void version() {
        ++this.version;
        File archive = new File(this.logFile.getAbsolutePath() + "." + this.version);
        if (this.log != null) {
            try {
                this.log.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.logFile.renameTo(archive);
    }
}

