/*
 * Decompiled with CFR 0.152.
 */
package org.dacapo.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;
import org.dacapo.parser.ConfigFile;
import org.dacapo.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private static int threadCountOverride = 0;
    public final String name;
    public String className = null;
    private ThreadModel threadModel = null;
    HashMap<String, Size> sizes = new HashMap(3);
    HashMap<String, String> desc = new HashMap(6);
    public String jar;
    public String[] libs;

    public static void setThreadCountOverride(int threadCount) {
        threadCountOverride = threadCount;
    }

    public static int getThreadCountOverride() {
        return threadCountOverride;
    }

    public static Config parse(String file) {
        return Config.parse(new File(file));
    }

    public static Config parse(File file) {
        try {
            return Config.parse(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Config parse(URL url) {
        try {
            return Config.parse(url.openStream());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Config parse(InputStream stream) {
        try {
            ConfigFile parser = new ConfigFile(stream);
            return parser.configFile();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            Config.parse(args[i]).print(System.out);
        }
    }

    Config(String name) {
        this.name = name;
    }

    void setJar(String jarName) throws ParseException {
        if (this.jar != null) {
            throw new ParseException("Configuration file error - cannot set jar name twice");
        }
        this.jar = jarName;
    }

    void setLibs(String[] libs) throws ParseException {
        if (this.libs != null) {
            throw new ParseException("Configuration file error - cannot set libs twice");
        }
        this.libs = libs;
    }

    void setClass(String className) throws ParseException {
        if (this.className != null) {
            throw new ParseException("Configuration file error - cannot set class name twice");
        }
        this.className = className;
    }

    void setThreadModel(ThreadModel model) throws ParseException {
        if (this.threadModel != null) {
            throw new ParseException("Configuration file error - cannot set thread model twice");
        }
        this.threadModel = model;
    }

    void addSize(String name, Vector<String> args) {
        this.sizes.put(name, new Size(name, args));
    }

    void addDesc(String element, String description) {
        this.desc.put(element, description);
    }

    void setThreadLimit(String size, int threadLimit) throws ParseException {
        if (this.threadModel == ThreadModel.SINGLE || this.threadModel == ThreadModel.FIXED) {
            throw new ParseException("Thread limit is not valid for Single and Fixed threading models");
        }
        if (threadLimit < 0) {
            throw new ParseException("Thread limit cannot be less than 0");
        }
        this.getSize(size).setThreadLimit(threadLimit);
    }

    public void setThreadFactor(String size, int nThreads) throws ParseException {
        if (this.threadModel == ThreadModel.SINGLE && nThreads != 1) {
            throw new ParseException("Single threaded benchmarks must have exactly 1 thread");
        }
        if (nThreads < 1) {
            throw new ParseException("Thread factor or number must be 1 or more");
        }
        this.getSize(size).setThreadCount(nThreads);
        if (this.threadModel == ThreadModel.SINGLE || this.threadModel == ThreadModel.FIXED) {
            this.getSize(size).setThreadLimit(nThreads);
        }
    }

    void setSizeDescription(String size, String description) throws ParseException {
        this.getSize(size).setDesc(description);
    }

    void addOutputFile(String size, String file) {
        this.getSize(size).addOutputFile(file);
        if (file.equals("stdout.log") || file.equals("stderr.log")) {
            this.setTextFile(size, file, true);
            this.setFilterScratch(size, file, true);
        }
    }

    void setDigest(String size, String file, String digest) {
        this.getSize((String)size).getOutputFile((String)file).digest = digest;
    }

    void setLines(String size, String file, int lines) {
        this.getSize((String)size).getOutputFile((String)file).lines = lines;
    }

    void setBytes(String size, String file, long bytes) {
        this.getSize((String)size).getOutputFile((String)file).bytes = bytes;
    }

    void setKeep(String size, String file) {
        this.getSize((String)size).getOutputFile((String)file).keep = true;
    }

    void setExists(String size, String file) {
        this.getSize((String)size).getOutputFile((String)file).existence = true;
    }

    public void setTextFile(String size, String file, boolean isText) {
        Size s = this.getSize(size);
        s.getOutputFile((String)file).text = isText;
    }

    public void setFilterScratch(String size, String file, boolean doFilter) {
        Size s = this.getSize(size);
        s.getOutputFile((String)file).filter = doFilter;
    }

    public String[] getArgs(String size) {
        return (String[])this.getSize((String)size).args.clone();
    }

    public Collection<String> getSizes() {
        return Collections.unmodifiableSet(this.sizes.keySet());
    }

    public ThreadModel getThreadModel() {
        if (this.threadModel == null) {
            return ThreadModel.FIXED;
        }
        return this.threadModel;
    }

    public int getThreadLimit(String size) {
        return this.getSize(size).getThreadLimit();
    }

    public int getThreadFactor(String size) {
        return this.getSize(size).getThreadCount();
    }

    public Set<String> getOutputs(String size) {
        return Collections.unmodifiableSet(this.getSize((String)size).outputFiles.keySet());
    }

    public String getDigest(String size, String file) {
        return this.getSize((String)size).getOutputFile((String)file).digest;
    }

    public boolean hasDigest(String size, String file) {
        return this.getSize(size).getOutputFile(file).hasDigest();
    }

    public boolean isTextFile(String size, String file) {
        Size s = this.getSize(size);
        return s.getOutputFile((String)file).text;
    }

    public boolean filterScratch(String size, String file) {
        return this.getSize((String)size).getOutputFile((String)file).filter;
    }

    public boolean hasBytes(String size, String file) {
        return this.getSize(size).getOutputFile(file).hasBytes();
    }

    public long getBytes(String size, String file) {
        return this.getSize((String)size).getOutputFile((String)file).bytes;
    }

    public boolean hasLines(String size, String file) {
        Size s = this.getSize(size);
        return s.getOutputFile(file).hasLines();
    }

    public int getLines(String size, String file) {
        Size s = this.getSize(size);
        return s.getOutputFile((String)file).lines;
    }

    public boolean isKept(String size, String file) {
        Size s = this.getSize(size);
        return s.getOutputFile((String)file).keep;
    }

    public boolean checkExists(String size, String file) {
        Size s = this.getSize(size);
        return s.getOutputFile((String)file).existence;
    }

    private String pad(String in, int length) {
        while (in.length() < length) {
            in = in + " ";
        }
        return in;
    }

    public void describe(PrintStream str, String size) {
        this.describe(str, size, false);
    }

    private void describe(PrintStream str, String size, boolean decorated, String desc, String trail) {
        if (decorated) {
            str.print("  ");
        }
        str.println(this.pad(desc, 10) + this.desc.get(desc) + (decorated ? trail : ""));
    }

    public void describe(PrintStream str, String size, boolean decorated) {
        String sizeDesc;
        if (decorated) {
            str.println("description");
        }
        this.describe(str, size, decorated, "short", ",");
        this.describe(str, size, decorated, "long", ",");
        this.describe(str, size, decorated, "author", ",");
        this.describe(str, size, decorated, "license", ",");
        this.describe(str, size, decorated, "copyright", ",");
        this.describe(str, size, decorated, "url", ",");
        String string = sizeDesc = size != null && this.getSize(size) != null ? this.getSize(size).getDesc() : null;
        if (sizeDesc == null) {
            this.describe(str, size, decorated, "version", ";");
        } else {
            this.describe(str, size, decorated, "version", ",");
            str.println(this.pad("size", 10) + sizeDesc + (decorated ? ";" : ""));
        }
    }

    public String getDesc(String item) {
        return this.desc.get(item);
    }

    public void print(PrintStream str) {
        str.print("benchmark " + this.name);
        if (this.className != null) {
            str.print(" class " + this.className);
        }
        str.println(";");
        str.print("  Threading model: ");
        if (this.threadModel == null) {
            str.println("unspecified");
        } else {
            str.println(this.threadModel.describe());
        }
        for (String size : this.getSizes()) {
            String[] args = this.getArgs(size);
            str.print("size " + size + " args \"");
            for (int j = 0; j < args.length; ++j) {
                if (j != 0) {
                    str.print(" ");
                }
                str.print(args[j]);
            }
            str.println("\"");
            str.print("  threads ");
            if (this.threadModel == null) {
                str.println("<specified in benchmark arguments>");
            } else {
                str.println(this.getThreadFactor(size));
            }
            str.print("  outputs");
            Iterator<String> v = this.getOutputs(size).iterator();
            while (v.hasNext()) {
                str.println();
                String file = v.next();
                OutputFile f = this.getSize(size).getOutputFile(file);
                str.print("    \"" + file + "\"");
                if (f.hasDigest()) {
                    str.print(" digest 0x" + f.digest);
                }
                if (f.keep) {
                    str.print(" keep");
                }
                if (!v.hasNext()) continue;
                str.print(",");
            }
            str.println(";");
        }
        this.describe(str, null, true);
    }

    public void printThreadModel(PrintStream str, String size, boolean verbose) {
        if (this.getThreadModel() == ThreadModel.PER_CPU) {
            str.println("Using scaled threading model. " + Runtime.getRuntime().availableProcessors() + " processors detected, " + this.getThreadCount(size) + " threads used to drive the workload, in a possible range of [1," + (this.getThreadLimit(size) == 0 ? "unlimited" : "" + this.getThreadLimit(size)) + "]");
        } else if (verbose) {
            if (this.getThreadModel() == ThreadModel.FIXED) {
                str.println("Using a fixed threading model. " + this.getThreadCount(size) + " threads used to drive the workload.");
            } else if (this.getThreadModel() == ThreadModel.SINGLE) {
                str.println("Using a single thread to drive the workload.");
            }
        }
    }

    public int getThreadCount(String size) {
        switch (this.getThreadModel()) {
            case SINGLE: {
                return 1;
            }
            case FIXED: {
                return this.getThreadFactor(size);
            }
            case PER_CPU: {
                return threadCountOverride != 0 ? threadCountOverride : this.getThreadFactor(size) * Runtime.getRuntime().availableProcessors();
            }
        }
        throw new RuntimeException("Unknown thread model");
    }

    public String[] preprocessArgs(String size, File scratch) {
        String[] raw = this.getArgs(size);
        String[] cooked = new String[raw.length];
        for (int i = 0; i < raw.length; ++i) {
            String tmp = raw[i];
            tmp = tmp.replace("${SCRATCH}", scratch.getAbsolutePath());
            cooked[i] = tmp = tmp.replace("${THREADS}", Integer.toString(this.getThreadCount(size)));
        }
        return cooked;
    }

    private Size getSize(String size) {
        Size s = this.sizes.get(size);
        if (s == null) {
            System.err.println("No such size: \"" + size + "\" for benchmark " + this.name);
            System.exit(-1);
        }
        return s;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Size {
        final String name;
        final String[] args;
        private int threadLimit = 0;
        private int nThreads = 1;
        private String description;
        HashMap<String, OutputFile> outputFiles = new LinkedHashMap<String, OutputFile>(20);

        Size(String name, Vector<String> args) {
            this.args = args.toArray(new String[0]);
            this.name = name;
        }

        void addOutputFile(String file) {
            this.outputFiles.put(file, new OutputFile(file));
        }

        OutputFile getOutputFile(String file) {
            return this.outputFiles.get(file);
        }

        void setThreadLimit(int threadLimit) {
            this.threadLimit = threadLimit;
        }

        int getThreadLimit() {
            return this.threadLimit;
        }

        void setThreadCount(int nThreads) {
            this.nThreads = nThreads;
        }

        int getThreadCount() {
            return this.nThreads;
        }

        void setDesc(String description) {
            this.description = description;
        }

        String getDesc() {
            return this.description;
        }
    }

    class OutputFile {
        String name;
        String digest = null;
        boolean keep = false;
        boolean existence = false;
        int lines = -1;
        long bytes = -1L;
        boolean text = false;
        boolean filter = false;

        OutputFile(String name) {
            this.name = name;
        }

        boolean hasDigest() {
            return this.digest != null;
        }

        boolean hasLines() {
            return this.lines != -1;
        }

        boolean hasBytes() {
            return this.bytes != -1L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ThreadModel {
        SINGLE("single threaded"),
        FIXED("fixed #threads"),
        PER_CPU("scaled to available CPUs");

        private String description;

        private ThreadModel(String description) {
            this.description = description;
        }

        public String describe() {
            return this.description;
        }
    }
}

