/*
 * Decompiled with CFR 0.152.
 */
package org.dacapo.parser;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.dacapo.parser.Config;
import org.dacapo.parser.ConfigFileConstants;
import org.dacapo.parser.ConfigFileTokenManager;
import org.dacapo.parser.ParseException;
import org.dacapo.parser.SimpleCharStream;
import org.dacapo.parser.Token;

class ConfigFile
implements ConfigFileConstants {
    public ConfigFileTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[19];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private List jj_expentries = new ArrayList();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public static void main(String[] args) {
        try {
            ConfigFile parser = new ConfigFile(new FileInputStream(args[0]));
            parser.configFile();
        }
        catch (ParseException p) {
            System.err.println("Parse exception");
            p.printStackTrace();
            return;
        }
        catch (FileNotFoundException e) {
            System.err.println("File " + args[0] + " not found.");
            return;
        }
        System.out.println("Success!");
    }

    private static String unQuote(Token token) {
        return token.image.substring(1, token.image.length() - 1);
    }

    private static String unHex(Token token) {
        return token.image.substring(2).toLowerCase();
    }

    public final Config configFile() throws ParseException {
        Config config = this.config();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 37: {
                    this.sizeSpec(config);
                    break;
                }
                case 20: {
                    this.description(config);
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 20: 
                case 37: {
                    continue block7;
                }
            }
            break;
        }
        this.jj_la1[1] = this.jj_gen;
        return config;
    }

    public final Config config() throws ParseException {
        this.jj_consume_token(15);
        Token name = this.jj_consume_token(47);
        Config config = new Config(name.image);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 18: 
                case 25: 
                case 27: 
                case 45: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            this.configOption(config);
        }
        this.jj_consume_token(54);
        return config;
    }

    public final void configOption(Config config) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                String className = this.identifier();
                config.setClass(className);
                break;
            }
            case 45: {
                this.jj_consume_token(45);
                Config.ThreadModel threadModel = this.threadModel();
                config.setThreadModel(threadModel);
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                String jar = this.string();
                config.setJar(jar);
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                this.libraries(config);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void libraries(Config config) throws ParseException {
        ArrayList<String> libs = new ArrayList<String>();
        String lib = this.string();
        libs.add(lib);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 51: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(51);
            lib = this.string();
            libs.add(lib);
        }
        config.setLibs(libs.toArray(new String[0]));
    }

    public final void sizeSpec(Config config) throws ParseException {
        this.jj_consume_token(37);
        Token size = this.jj_consume_token(47);
        block3: while (true) {
            this.sizeClause(config, size.image);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: 
                case 20: 
                case 32: 
                case 43: 
                case 44: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[5] = this.jj_gen;
        this.jj_consume_token(54);
    }

    public final void sizeClause(Config config, String size) throws ParseException {
        Vector<String> args = new Vector<String>();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                this.jj_consume_token(13);
                block7 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 49: {
                        String arg = this.string();
                        args.add(arg);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 51: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[6] = this.jj_gen;
                                    break block7;
                                }
                            }
                            this.jj_consume_token(51);
                            arg = this.string();
                            args.add(arg);
                        }
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                    }
                }
                config.addSize(size, args);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                String description = this.string();
                config.setSizeDescription(size, description);
                break;
            }
            case 44: {
                this.jj_consume_token(44);
                int thread_limit = this.integer();
                config.setThreadLimit(size, thread_limit);
                break;
            }
            case 43: {
                this.jj_consume_token(43);
                int threads = this.integer();
                config.setThreadFactor(size, threads);
                break;
            }
            case 32: {
                this.jj_consume_token(32);
                this.outputFile(config, size);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 51: {
                            break;
                        }
                        default: {
                            this.jj_la1[8] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(51);
                    this.outputFile(config, size);
                }
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void outputFile(Config config, String size) throws ParseException {
        String file;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 49: {
                file = this.string();
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                file = "stdout.log";
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                file = "stderr.log";
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        config.addOutputFile(size, file);
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: 
                case 21: 
                case 22: 
                case 26: 
                case 29: {
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    break block8;
                }
            }
            this.outputClause(config, size, file);
        }
    }

    public final void outputClause(Config config, String size, String file) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: {
                this.jj_consume_token(21);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 52: {
                        this.jj_consume_token(52);
                        this.digestOption(config, size, file);
                        block13: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 51: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[12] = this.jj_gen;
                                    break block13;
                                }
                            }
                            this.jj_consume_token(51);
                            this.digestOption(config, size, file);
                        }
                        this.jj_consume_token(53);
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                    }
                }
                String digest = this.hex();
                config.setDigest(size, file, digest);
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                config.setExists(size, file);
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                config.setKeep(size, file);
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                int n = this.integer();
                config.setLines(size, file, n);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                long l = this.longInt();
                config.setBytes(size, file, l);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void digestOption(Config config, String size, String file) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: {
                this.jj_consume_token(40);
                config.setTextFile(size, file, true);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                config.setTextFile(size, file, false);
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                config.setFilterScratch(size, file, true);
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                config.setFilterScratch(size, file, false);
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Config.ThreadModel threadModel() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: {
                this.jj_consume_token(36);
                return Config.ThreadModel.SINGLE;
            }
            case 24: {
                this.jj_consume_token(24);
                return Config.ThreadModel.FIXED;
            }
            case 33: {
                this.jj_consume_token(33);
                return Config.ThreadModel.PER_CPU;
            }
        }
        this.jj_la1[16] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void description(Config config) throws ParseException {
        this.jj_consume_token(20);
        this.descElement(config);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 51: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(51);
            this.descElement(config);
        }
        this.jj_consume_token(54);
    }

    public final void descElement(Config config) throws ParseException {
        String id = this.descId();
        String desc = this.string();
        config.addDesc(id, desc);
    }

    public final String descId() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                break;
            }
            case 28: {
                this.jj_consume_token(28);
                break;
            }
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                break;
            }
            case 43: {
                this.jj_consume_token(43);
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                break;
            }
            case 41: {
                this.jj_consume_token(41);
                break;
            }
            case 42: {
                this.jj_consume_token(42);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image;
    }

    public final String identifier() throws ParseException {
        this.jj_consume_token(47);
        return this.token.image;
    }

    public final String string() throws ParseException {
        this.jj_consume_token(49);
        return ConfigFile.unQuote(this.token);
    }

    public final int integer() throws ParseException {
        this.jj_consume_token(50);
        return Integer.parseInt(this.token.image);
    }

    public final long longInt() throws ParseException {
        this.jj_consume_token(50);
        return Long.parseLong(this.token.image);
    }

    public final String hex() throws ParseException {
        this.jj_consume_token(48);
        return ConfigFile.unHex(this.token);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0x100000, 0x100000, 0xA040000, 0xA040000, 0, 0x102000, 0, 0, 0, 0x102000, 0, 610402304, 0, 0, 610402304, 0x810000, 0x1000000, 0, 1342717952};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{32, 32, 8192, 8192, 524288, 6145, 524288, 131072, 524288, 6145, 131264, 0, 524288, 0x100000, 0, 260, 18, 524288, 19976};
    }

    public ConfigFile(InputStream stream) {
        this(stream, null);
    }

    public ConfigFile(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ConfigFileTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 19; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 19; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ConfigFile(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ConfigFileTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 19; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 19; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ConfigFile(ConfigFileTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 19; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(ConfigFileTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 19; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[55];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 19; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 55; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        ConfigFile.jj_la1_init_0();
        ConfigFile.jj_la1_init_1();
    }
}

