/*
 * Decompiled with CFR 0.152.
 */
package org.dacapo.tomcat;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.dacapo.tomcat.Session;

public class AuthenticatedSession
extends Session {
    private final String username;
    private final String password;

    public static Session create(String username, String password, int port) {
        return new AuthenticatedSession(username, password, port).init();
    }

    protected AuthenticatedSession(String username, String password, int port) {
        super(port);
        this.username = username;
        this.password = password;
    }

    protected void setClientState(HttpState state) {
        super.setClientState(state);
        UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(this.username, this.password);
        state.setCredentials(new AuthScope("localhost", this.port, AuthScope.ANY_REALM), (Credentials)defaultcreds);
    }

    protected void setClientParams(HttpClientParams params) {
        super.setClientParams(params);
        params.setAuthenticationPreemptive(true);
    }
}

