/**********************************************************************
Copyright (c) 2017 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
     ...
 **********************************************************************/
package org.datanucleus.state;

/**
 * Locking modes for persistable objects.
 */
public enum LockMode
{
    /** No locking specified. Use default type. */
    LOCK_NONE,

    /** Optimistic locking. */
    LOCK_OPTIMISTIC_READ,

    /** Optimistic locking, plus forced version update at commit. */
    LOCK_OPTIMISTIC_WRITE,

    /** Pessimistic locking. */
    LOCK_PESSIMISTIC_READ,

    /** Pessimistic locking, plus forced version update at commit. */
    LOCK_PESSIMISTIC_WRITE;
}
