/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.datastore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.ClassConstants;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.exceptions.UnsupportedDataTypeException;
import org.datanucleus.store.rdbms.mapping.datastore.DatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.Localiser;

public abstract class AbstractDatastoreMapping
implements DatastoreMapping {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected final JavaTypeMapping mapping;
    protected final RDBMSStoreManager storeMgr;
    protected Column column;

    protected AbstractDatastoreMapping(RDBMSStoreManager storeMgr, JavaTypeMapping mapping) {
        this.mapping = mapping;
        if (mapping != null) {
            mapping.addDatastoreMapping(this);
        }
        this.storeMgr = storeMgr;
    }

    @Override
    public JavaTypeMapping getJavaTypeMapping() {
        return this.mapping;
    }

    protected DatastoreAdapter getDatastoreAdapter() {
        return this.storeMgr.getDatastoreAdapter();
    }

    public abstract SQLTypeInfo getTypeInfo();

    @Override
    public boolean isNullable() {
        if (this.column != null) {
            return this.column.isNullable();
        }
        return true;
    }

    public boolean includeInFetchStatement() {
        return true;
    }

    public boolean insertValuesOnInsert() {
        return this.getInsertionInputParameter().indexOf(63) > -1;
    }

    public String getInsertionInputParameter() {
        return this.column.getWrapperFunction(1);
    }

    public String getUpdateInputParameter() {
        return this.column.getWrapperFunction(2);
    }

    @Override
    public Column getColumn() {
        return this.column;
    }

    protected void initTypeInfo() {
        SQLTypeInfo typeInfo = this.getTypeInfo();
        if (typeInfo == null) {
            throw new UnsupportedDataTypeException(LOCALISER_RDBMS.msg("055000", (Object)this.column));
        }
        if (this.column != null) {
            this.column.setTypeInfo(typeInfo);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractDatastoreMapping)) {
            return false;
        }
        AbstractDatastoreMapping cm = (AbstractDatastoreMapping)obj;
        return this.getClass().equals(cm.getClass()) && ((Object)((Object)this.storeMgr)).equals((Object)cm.storeMgr) && (this.column == null ? cm.column == null : this.column.equals(cm.column));
    }

    public int hashCode() {
        return ((Object)((Object)this.storeMgr)).hashCode() ^ (this.column == null ? 0 : this.column.hashCode());
    }

    protected String failureMessage(String method, int position, Exception e) {
        return LOCALISER_RDBMS.msg("041050", (Object)(this.getClass().getName() + "." + method), (Object)position, (Object)this.column, (Object)e.getMessage());
    }

    protected String failureMessage(String method, Object value, Exception e) {
        return LOCALISER_RDBMS.msg("041050", (Object)(this.getClass().getName() + "." + method), value, (Object)this.column, (Object)e.getMessage());
    }

    @Override
    public void setBoolean(PreparedStatement ps, int exprIndex, boolean value) {
        throw new NucleusException(this.failureMessage("setBoolean")).setFatal();
    }

    @Override
    public boolean getBoolean(ResultSet resultSet, int exprIndex) {
        throw new NucleusException(this.failureMessage("getBoolean")).setFatal();
    }

    @Override
    public void setChar(PreparedStatement ps, int exprIndex, char value) {
        throw new NucleusException(this.failureMessage("setChar")).setFatal();
    }

    @Override
    public char getChar(ResultSet resultSet, int exprIndex) {
        throw new NucleusException(this.failureMessage("getChar")).setFatal();
    }

    @Override
    public void setByte(PreparedStatement ps, int exprIndex, byte value) {
        throw new NucleusException(this.failureMessage("setByte")).setFatal();
    }

    @Override
    public byte getByte(ResultSet resultSet, int exprIndex) {
        throw new NucleusException(this.failureMessage("getByte")).setFatal();
    }

    @Override
    public void setShort(PreparedStatement ps, int exprIndex, short value) {
        throw new NucleusException(this.failureMessage("setShort")).setFatal();
    }

    @Override
    public short getShort(ResultSet resultSet, int exprIndex) {
        throw new NucleusException(this.failureMessage("getShort")).setFatal();
    }

    @Override
    public void setInt(PreparedStatement ps, int exprIndex, int value) {
        throw new NucleusException(this.failureMessage("setInt")).setFatal();
    }

    @Override
    public int getInt(ResultSet resultSet, int exprIndex) {
        throw new NucleusException(this.failureMessage("getInt")).setFatal();
    }

    @Override
    public void setLong(PreparedStatement ps, int exprIndex, long value) {
        throw new NucleusException(this.failureMessage("setLong")).setFatal();
    }

    @Override
    public long getLong(ResultSet resultSet, int exprIndex) {
        throw new NucleusException(this.failureMessage("getLong")).setFatal();
    }

    @Override
    public void setFloat(PreparedStatement ps, int exprIndex, float value) {
        throw new NucleusException(this.failureMessage("setFloat")).setFatal();
    }

    @Override
    public float getFloat(ResultSet resultSet, int exprIndex) {
        throw new NucleusException(this.failureMessage("getFloat")).setFatal();
    }

    @Override
    public void setDouble(PreparedStatement ps, int exprIndex, double value) {
        throw new NucleusException(this.failureMessage("setDouble")).setFatal();
    }

    @Override
    public double getDouble(ResultSet resultSet, int exprIndex) {
        throw new NucleusException(this.failureMessage("getDouble")).setFatal();
    }

    @Override
    public void setString(PreparedStatement ps, int exprIndex, String value) {
        throw new NucleusException(this.failureMessage("setString")).setFatal();
    }

    @Override
    public String getString(ResultSet resultSet, int exprIndex) {
        throw new NucleusException(this.failureMessage("getString")).setFatal();
    }

    @Override
    public void setObject(PreparedStatement ps, int exprIndex, Object value) {
        throw new NucleusException(this.failureMessage("setObject")).setFatal();
    }

    @Override
    public Object getObject(ResultSet resultSet, int exprIndex) {
        throw new NucleusException(this.failureMessage("getObject")).setFatal();
    }

    @Override
    public boolean isDecimalBased() {
        return false;
    }

    @Override
    public boolean isIntegerBased() {
        return false;
    }

    @Override
    public boolean isStringBased() {
        return false;
    }

    @Override
    public boolean isBitBased() {
        return false;
    }

    @Override
    public boolean isBooleanBased() {
        return false;
    }

    protected String failureMessage(String method) {
        return LOCALISER_RDBMS.msg("041005", (Object)this.getClass().getName(), (Object)method, (Object)this.mapping.getMemberMetaData().getFullFieldName());
    }
}

