/**********************************************************************
Copyright (c) 2011 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;

import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.util.Localiser;

/**
 * Method for evaluating {strExpr1}.equalsIgnoreCase(strExpr2).
 * Returns a BooleanExpression that equates to <pre>{strExpr1}.toUpperCase() = {strExpr2}.toUpperCase()</pre>
 */
public class StringEqualsIgnoreCaseMethod extends AbstractSQLMethod
{
    /* (non-Javadoc)
     * @see org.datanucleus.store.rdbms.sql.method.SQLMethod#getExpression(org.datanucleus.store.rdbms.sql.expression.SQLExpression, java.util.List)
     */
    public SQLExpression getExpression(SQLExpression expr, List<SQLExpression> args)
    {
        if (args == null || args.size() != 1)
        {
            throw new NucleusException(Localiser.msg("060003", "endsWith", "StringExpression", 0,
                "StringExpression/CharacterExpression/ParameterLiteral"));
        }

        StringExpression strExpr1 = (StringExpression)expr;
        StringExpression strExpr2 = (StringExpression)args.get(0);
        SQLExpression str1Upper = strExpr1.invoke("toUpperCase", null);
        SQLExpression str2Upper = strExpr2.invoke("toUpperCase", null);
        return str1Upper.eq(str2Upper);
    }
}