/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import javax.servlet.http.HttpServlet;
import org.directwebremoting.util.LoggingOutput;

public class ServletLoggingOutput
implements LoggingOutput {
    private static final ThreadLocal servlets = new ThreadLocal();
    private static int level = 3;

    public void debug(String message) {
        ServletLoggingOutput.log(1, message, null);
    }

    public void info(String message) {
        ServletLoggingOutput.log(2, message, null);
    }

    public void warn(String message) {
        ServletLoggingOutput.log(3, message, null);
    }

    public void warn(String message, Throwable th) {
        ServletLoggingOutput.log(3, message, th);
    }

    public void error(String message) {
        ServletLoggingOutput.log(4, message, null);
    }

    public void error(String message, Throwable th) {
        ServletLoggingOutput.log(4, message, th);
    }

    public void fatal(String message) {
        ServletLoggingOutput.log(5, message, null);
    }

    public void fatal(String message, Throwable th) {
        ServletLoggingOutput.log(5, message, th);
    }

    private static void log(int loglevel, String message, Throwable th) {
        if (loglevel >= level) {
            HttpServlet servlet = (HttpServlet)servlets.get();
            if (servlet != null) {
                if (th == null) {
                    servlet.log(message);
                } else {
                    servlet.log(message, th);
                }
            } else {
                if (message != null) {
                    System.out.println(message);
                }
                if (th != null) {
                    th.printStackTrace();
                }
            }
        }
    }

    public static void setExecutionContext(HttpServlet servlet) {
        servlets.set(servlet);
    }

    public static void unsetExecutionContext() {
        servlets.set(null);
    }

    public static void setLevel(String logLevel) {
        if (logLevel.equalsIgnoreCase("FATAL")) {
            ServletLoggingOutput.setLevel(5);
        } else if (logLevel.equalsIgnoreCase("ERROR")) {
            ServletLoggingOutput.setLevel(4);
        } else if (logLevel.equalsIgnoreCase("WARN")) {
            ServletLoggingOutput.setLevel(3);
        } else if (logLevel.equalsIgnoreCase("INFO")) {
            ServletLoggingOutput.setLevel(2);
        } else if (logLevel.equalsIgnoreCase("DEBUG")) {
            ServletLoggingOutput.setLevel(1);
        } else {
            throw new IllegalArgumentException("Unknown log level: " + logLevel);
        }
    }

    public boolean isDebugEnabled() {
        return level == 1;
    }

    public static void setLevel(int level) {
        ServletLoggingOutput.level = level;
    }

    public static int getLevel() {
        return level;
    }
}

