/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.encoding;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.encoding.Precoded;
import org.dmfs.rfc3986.validation.CharSets;

public final class Normalized
implements UriEncoded {
    private final UriEncoded mDelegate;
    private CharSequence mNormalized;

    public Normalized(UriEncoded delegate) {
        this.mDelegate = delegate;
    }

    @Override
    public UriEncoded normalized() {
        return this;
    }

    @Override
    public CharSequence decoded(String charset) throws UnsupportedEncodingException {
        return this.mDelegate.decoded(charset);
    }

    @Override
    public CharSequence decoded() {
        return this.mDelegate.decoded();
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int i) {
        return this.toString().charAt(i);
    }

    @Override
    public UriEncoded subSequence(int startIndex, int endIndex) {
        if (startIndex == 0 && endIndex == this.toString().length()) {
            return this;
        }
        return new Precoded(this.toString().subSequence(startIndex, endIndex));
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UriEncoded)) {
            return false;
        }
        return this.toString().equals(((UriEncoded)obj).normalized().toString());
    }

    @Override
    public String toString() {
        if (this.mNormalized == null) {
            this.mNormalized = this.normalized(this.mDelegate);
        }
        return this.mNormalized.toString();
    }

    private CharSequence normalized(CharSequence encoded) {
        if (encoded.length() == 0) {
            return encoded;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(encoded.length());
        int count = encoded.length();
        int i = 0;
        while (i < count) {
            char c = encoded.charAt(i);
            if (c == '%') {
                if (i + 2 >= count) {
                    throw new IllegalArgumentException("Illegal encoding");
                }
                int value = (this.decodeDigit(encoded.charAt(i + 1)) << 4) + this.decodeDigit(encoded.charAt(i + 2));
                if (CharSets.UNRESERVED.contains((char)value)) {
                    out.write(value);
                    i += 3;
                    continue;
                }
                out.write(37);
                char high = encoded.charAt(i + 1);
                if (high >= 'a') {
                    out.write(high & 0xFFDF);
                } else {
                    out.write(high);
                }
                char low = encoded.charAt(i + 2);
                if (low >= 'a') {
                    out.write(low & 0xFFDF);
                } else {
                    out.write(low);
                }
                i += 3;
                continue;
            }
            out.write(c);
            ++i;
        }
        try {
            return out.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Runtime doesn't support UTF-8");
        }
    }

    private int decodeDigit(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        int r = c - 65 & 0xFFFFFFDF;
        if (r < 0 || r > 5) {
            throw new IllegalArgumentException(String.format("%c is not a valid hex digit", new Object[0]));
        }
        return r + 10;
    }
}

