/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.encoding.utils;

import java.io.IOException;
import java.io.OutputStream;
import org.dmfs.rfc3986.validation.CharSet;

public final class FormPercentEncodingOutputStream
extends OutputStream {
    private static final char[] HEXDIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final StringBuilder mStringBuilder;
    private final CharSet mNoEncodeMap;

    public FormPercentEncodingOutputStream(int initialCapacity, CharSet noEncodeMap) {
        this.mStringBuilder = new StringBuilder(initialCapacity);
        this.mNoEncodeMap = noEncodeMap;
    }

    @Override
    public void write(int i) throws IOException {
        if (this.mNoEncodeMap.contains((char)i)) {
            this.mStringBuilder.append((char)i);
        } else if (i == 32) {
            this.mStringBuilder.append('+');
        } else if (i == 10) {
            this.mStringBuilder.append("%0D%0A");
        } else if (i != 13) {
            this.mStringBuilder.append('%');
            this.mStringBuilder.append(HEXDIGITS[i >>> 4 & 0xF]);
            this.mStringBuilder.append(HEXDIGITS[i & 0xF]);
        }
    }

    public String toString() {
        return this.mStringBuilder.toString();
    }
}

