/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.paths;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.dmfs.iterators.EmptyIterator;
import org.dmfs.rfc3986.Path;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.encoding.IdempotentEncoded;

public final class Normalized
implements Path {
    private final Path mDelegate;

    public Normalized(Path delegate) {
        this.mDelegate = delegate;
    }

    @Override
    public boolean isEmpty() {
        return this.mDelegate.isEmpty();
    }

    @Override
    public boolean isAbsolute() {
        return this.mDelegate.isAbsolute();
    }

    @Override
    public Iterator<UriEncoded> iterator() {
        if (this.mDelegate.isEmpty()) {
            return EmptyIterator.instance();
        }
        return Collections.unmodifiableList(this.normalize(this.mDelegate.iterator())).iterator();
    }

    private List<UriEncoded> normalize(Iterator<UriEncoded> segments) {
        LinkedList<UriEncoded> pathSegments = new LinkedList<UriEncoded>();
        int count = 0;
        int backSteps = 0;
        boolean isAbsolute = false;
        boolean endWithEmptySegment = false;
        boolean singleDot = false;
        while (segments.hasNext()) {
            UriEncoded segment = segments.next().normalized();
            if (IdempotentEncoded.EMPTY.equals(segment)) {
                if (count == 0) {
                    isAbsolute = true;
                } else {
                    endWithEmptySegment = true;
                }
            } else if (IdempotentEncoded.CURRENT.equals(segment)) {
                if (pathSegments.isEmpty() && !isAbsolute) {
                    singleDot = true;
                } else {
                    endWithEmptySegment = true;
                }
            } else if (IdempotentEncoded.PARENT.equals(segment)) {
                if (backSteps > 0) {
                    pathSegments.removeLast();
                    --backSteps;
                } else if (!isAbsolute) {
                    pathSegments.addLast(segment);
                }
                endWithEmptySegment = true;
                singleDot = pathSegments.isEmpty() && !isAbsolute;
            } else {
                pathSegments.addLast(segment);
                ++backSteps;
                endWithEmptySegment = false;
                singleDot = false;
            }
            ++count;
        }
        if (isAbsolute) {
            pathSegments.addFirst(IdempotentEncoded.EMPTY);
        }
        if (singleDot) {
            pathSegments.addLast(IdempotentEncoded.CURRENT);
            pathSegments.addLast(IdempotentEncoded.EMPTY);
        } else if (endWithEmptySegment && (pathSegments.size() <= 1 || !IdempotentEncoded.EMPTY.equals(pathSegments.getLast()))) {
            pathSegments.addLast(IdempotentEncoded.EMPTY);
        }
        return pathSegments;
    }
}

