/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in.word2003xml;

import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.util.JAXBResult;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.docx4j.XmlUtils;
import org.docx4j.convert.in.word2003xml.Transition03To06;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.FontTablePart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.utils.ResourceUtils;
import org.docx4j.wml.Document;
import org.docx4j.wml.Numbering;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Word2003XmlConverter {
    private static Logger log = LoggerFactory.getLogger(Word2003XmlConverter.class);
    static Templates xslt;
    private Transition03To06 transitionContainer;

    public Word2003XmlConverter(Source source) throws JAXBException, Docx4JException {
        ClassLoader classLoader = Word2003XmlConverter.class.getClassLoader();
        JAXBResult result = new JAXBResult(JAXBContext.newInstance((String)"org.docx4j.convert.in.word2003xml", (ClassLoader)classLoader));
        XmlUtils.transform(source, xslt, null, (Result)result);
        this.transitionContainer = (Transition03To06)result.getResult();
    }

    private WordprocessingMLPackage getWordprocessingMLPackage() {
        return this.getWordprocessingMLPackage(false);
    }

    private WordprocessingMLPackage getWordprocessingMLPackage(boolean mainDocOnly) {
        WordprocessingMLPackage wordMLPackage = null;
        try {
            wordMLPackage = WordprocessingMLPackage.createPackage();
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
        MainDocumentPart mdp = wordMLPackage.getMainDocumentPart();
        ((Document)mdp.getJaxbElement()).setBody(this.transitionContainer.getBody());
        if (!mainDocOnly) {
            mdp.getStyleDefinitionsPart(true).setJaxbElement(this.transitionContainer.getStyles());
            try {
                NumberingDefinitionsPart ndp = new NumberingDefinitionsPart();
                ndp.setJaxbElement(this.transitionContainer.getNumbering());
                mdp.addTargetPart(ndp);
                for (Numbering.AbstractNum anum : ((Numbering)ndp.getJaxbElement()).getAbstractNum()) {
                    if (anum.getMultiLevelType() == null) continue;
                    Object multiLevelType = anum.getMultiLevelType().getVal();
                    multiLevelType = ((String)multiLevelType).substring(0, 1).toLowerCase() + ((String)multiLevelType).substring(1);
                    anum.getMultiLevelType().setVal((String)multiLevelType);
                }
            }
            catch (InvalidFormatException ndp) {
                // empty catch block
            }
            try {
                FontTablePart fontsPart = new FontTablePart();
                fontsPart.setJaxbElement(this.transitionContainer.getFonts());
                mdp.addTargetPart(fontsPart);
            }
            catch (InvalidFormatException invalidFormatException) {
                // empty catch block
            }
        }
        return wordMLPackage;
    }

    public static void main(String[] args) throws IOException, JAXBException, Docx4JException {
        boolean save = true;
        File file = new File(System.getProperty("user.dir") + "/sample-docs/word/2003/word2003xml.xml");
        StreamSource source = new StreamSource(FileUtils.openInputStream((File)file));
        Word2003XmlConverter conv = new Word2003XmlConverter(source);
        WordprocessingMLPackage wordMLPackage = conv.getWordprocessingMLPackage();
        if (save) {
            String filename = System.getProperty("user.dir") + "/OUT_FromWord2003XML.docx";
            wordMLPackage.save(new File(filename));
            System.out.println("Saved " + filename);
        }
    }

    static {
        try {
            StreamSource xsltSource = new StreamSource(ResourceUtils.getResource("org/docx4j/convert/in/word2003xml/2003-import.xslt"));
            xslt = XmlUtils.getTransformerTemplate(xsltSource);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("Couldn't setup 2003-import.xslt", (Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            log.error("Couldn't setup 2003-import.xslt", (Throwable)e);
        }
    }
}

