/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.apache.poi.hpsf;

import org.docx4j.org.apache.poi.util.Internal;
import org.docx4j.org.apache.poi.util.LittleEndian;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
class VariantBool {
    private static Logger logger = LoggerFactory.getLogger(VariantBool.class);
    static final int SIZE = 2;
    private boolean _value;

    VariantBool(byte[] data, int offset) {
        short value = LittleEndian.getShort(data, offset);
        if (value == 0) {
            this._value = false;
            return;
        }
        if (value == 65535) {
            this._value = true;
            return;
        }
        logger.warn("VARIANT_BOOL value '", (Object)value, (Object)"' is incorrect");
        this._value = value != 0;
    }

    boolean getValue() {
        return this._value;
    }

    void setValue(boolean value) {
        this._value = value;
    }
}

